% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullyParametricCopulas.R
\name{TCsim}
\alias{TCsim}
\title{Function to simulate (Y,Delta) from the copula based model for (T,C).}
\usage{
TCsim(
  tau = 0,
  Copula = "frank",
  Dist.T = "lnorm",
  Dist.C = "lnorm",
  par.T = c(0, 1),
  par.C = c(0, 1),
  n = 10000
)
}
\arguments{
\item{tau}{Value of Kendall's tau for (T,C). The default value is 0.}

\item{Copula}{The copula family. This argument can take values from \code{c("frank","gumbel","clayton","gaussian","indep")}. The default copula model is "frank".}

\item{Dist.T}{Distribution of the survival time T. This argument can take one of the values from \code{c("lnorm", "weibull", "llogis")}. The default distribution is "lnorm".}

\item{Dist.C}{Distribution of the censoring time C. This argument can take one of the values from \code{c("lnorm", "weibull", "llogis")}. The default distribution is "lnorm".}

\item{par.T}{Parameter values for the distribution of T.}

\item{par.C}{Parameter values for the distribution of C.}

\item{n}{Sample size.}
}
\value{
A list containing the generated follow-up times and censoring indicators.
}
\description{
Generates the follow-up time and censoring indicator according to the specified model.
}
\examples{
tau = 0.5
Copula = "gaussian"
Dist.T = "lnorm"
Dist.C = "lnorm"
par.T = c(1,1)
par.C = c(2,2)
n=1000

simdata <- TCsim(tau,Copula,Dist.T,Dist.C,par.T,par.C,n)
Y = simdata[[1]]
Delta = simdata[[2]]
hist(Y)
mean(Delta)

}
