% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rw.R
\name{get_RW}
\alias{get_RW}
\title{Get ring widths from identified tree rings}
\usage{
get_RW(rings)
}
\arguments{
\item{rings}{A data frame with the identified rings, a result of
the dprings() call on an individual profile}
}
\value{
A vector of ring widths, which are peak-to-peak differences.
}
\description{
Called on an object returned by \code{dprings}, it will return ring
widths for all detected rings. The units are determined by the
xUnit from the footer of density profile.
}
\examples{
## load a single file
dp  <- dpload(system.file("extdata", "00010001.dpa", package = "densitr"))
## trim and detrend the measurement
dp.trimmed <- dptrim(dp)
dp.detrended <- dpdetrend(dp.trimmed, type = "gam")
## identify rings
rings <- dprings(dp.detrended)
## get tree ring widths:
get_RW(rings)
}
\seealso{
dprings
}
