% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monthly_response_seascorr.R
\name{monthly_response_seascorr}
\alias{monthly_response_seascorr}
\title{monthly_response_seascorr}
\usage{
monthly_response_seascorr(
  response,
  env_data_primary,
  env_data_control,
  previous_year = FALSE,
  pcor_method = "pearson",
  remove_insignificant = TRUE,
  lower_limit = 1,
  upper_limit = 12,
  fixed_width = 0,
  alpha = 0.05,
  row_names_subset = FALSE,
  PCA_transformation = FALSE,
  log_preprocess = TRUE,
  components_selection = "automatic",
  eigenvalues_threshold = 1,
  N_components = 2,
  aggregate_function_env_data_primary = "mean",
  aggregate_function_env_data_control = "mean",
  temporal_stability_check = "sequential",
  k = 2,
  k_running_window = 30,
  cross_validation_type = "blocked",
  subset_years = NULL,
  plot_specific_window = NULL,
  ylimits = NULL,
  seed = NULL,
  tidy_env_data_primary = FALSE,
  tidy_env_data_control = FALSE,
  boot = FALSE,
  boot_n = 1000,
  boot_ci_type = "norm",
  boot_conf_int = 0.95,
  month_interval = ifelse(c(previous_year == TRUE, previous_year == TRUE), c(-1, 12),
    c(1, 12)),
  dc_method = NULL,
  dc_nyrs = NULL,
  dc_f = 0.5,
  dc_pos.slope = FALSE,
  dc_constrain.nls = c("never", "when.fail", "always"),
  dc_span = "cv",
  dc_bass = 0,
  dc_difference = FALSE
)
}
\arguments{
\item{response}{a data frame with tree-ring proxy variable and (optional)
years as row names. Row.names should be matched with those from env_data_primary
and env_data_control data frame. If not, set the row_names_subset argument to
TRUE.}

\item{env_data_primary}{primary data frame of monthly sequences of environmental
data as columns and years as row names. Each row represents a year and
each column represents a day of a year. Row.names should be matched with
those from the response data frame. If not, set the argument row_names_subset
to TRUE. Alternatively, env_data_primary could be a tidy data with three columns,
i.e. Year, Month and third column representing values of mean temperatures,
sum of precipitation etc. If tidy data is passed to the function, set the argument
tidy_env_data_primary to TRUE.}

\item{env_data_control}{a data frame of monthly sequences of environmental data as
columns and years as row names. This data is used as control for calculations of
partial correlation coefficients. Each row represents a year and each column
represents a day of a year. Row.names should be matched with those from the
response data frame. If not, set the row_names_subset argument to TRUE.
Alternatively, env_data_control could be a tidy data with three columns,
i.e. Year, Month and third column representing values of mean temperatures, sum
of precipitation etc. If tidy data is passed to the function, set the argument
tidy_env_data_control to TRUE.}

\item{previous_year}{if set to TRUE, env_data_primary, env_data_control and
response variables will be rearranged in a way, that also previous year will
be used for calculations of selected statistical metric.}

\item{pcor_method}{a character string indicating which partial correlation
coefficient is to be computed. One of "pearson" (default), "kendall", or
"spearman", can be abbreviated.}

\item{remove_insignificant}{if set to TRUE, removes all correlations bellow
the significant threshold level, based on a selected alpha.}

\item{lower_limit}{lower limit of window width (i.e. number of consecutive months
to be used for calculations)}

\item{upper_limit}{upper limit of window width (i.e. number of consecutive months
to be used for calculations)}

\item{fixed_width}{fixed width used for calculations (i.e. number of consecutive
months to be used for calculations)}

\item{alpha}{significance level used to remove insignificant calculations.}

\item{row_names_subset}{if set to TRUE, row.names are used to subset
env_data_primary, env_data_control and response data frames. Only years from
all three data frames are kept.}

\item{PCA_transformation}{if set to TRUE, all variables in the response
data frame will be transformed using PCA transformation.}

\item{log_preprocess}{if set to TRUE, variables will be transformed with
logarithmic transformation before used in PCA}

\item{components_selection}{character string specifying how to select the Principal
Components used as predictors.
There are three options: "automatic", "manual" and "plot_selection". If
argument is set to automatic, all scores with eigenvalues above 1 will be
selected. This threshold could be changed by changing the
eigenvalues_threshold argument. If parameter is set to "manual", user should
set the number of components with N_components argument. If components
selection is set to "plot_selection", Scree plot will be shown and a user must
manually enter the number of components to be used as predictors.}

\item{eigenvalues_threshold}{threshold for automatic selection of Principal Components}

\item{N_components}{number of Principal Components used as predictors}

\item{aggregate_function_env_data_primary}{character string specifying how the
monthly data from env_data_primary should be aggregated. The default is 'mean',
the two other options are 'median' and 'sum'}

\item{aggregate_function_env_data_control}{character string specifying how the
monthly data from env_data_control should be aggregated. The default is 'mean',
the two other options are 'median' and 'sum'}

\item{temporal_stability_check}{character string, specifying, how temporal stability
between the optimal selection and response variable(s) will be analysed. Current
possibilities are "sequential", "progressive" and "running_window". Sequential check
will split data into k splits and calculate selected metric for each split. Progressive
check will split data into k splits, calculate metric for the first split and then
progressively add 1 split at a time and calculate selected metric. For running window,
select the length of running window with the k_running_window argument.}

\item{k}{integer, number of breaks (splits) for temporal stability and cross validation
analysis.}

\item{k_running_window}{the length of running window for temporal stability check.
Applicable only if temporal_stability argument is set to running window.}

\item{cross_validation_type}{character string, specifying, how to perform cross validation
between the optimal selection and response variables. If the argument is set to "blocked",
years will not be shuffled. If the argument is set to "randomized", years will be shuffled.}

\item{subset_years}{a subset of years to be analyzed. Should be given in the form of
subset_years = c(1980, 2005)}

\item{plot_specific_window}{integer representing window width to be displayed
for plot_specific}

\item{ylimits}{limit of the y axes for plot_extreme and plot_specific. It should be
given in the form of: ylimits = c(0,1)}

\item{seed}{optional seed argument for reproducible results}

\item{tidy_env_data_primary}{if set to TRUE, env_data_primary should be inserted as a
data frame with three columns: "Year", "Month", "Precipitation/Temperature/etc."}

\item{tidy_env_data_control}{if set to TRUE, env_data_control should be inserted as a
data frame with three columns: "Year", "Month", "Precipitation/Temperature/etc."}

\item{boot}{logical, if TRUE, bootstrap procedure will be used to calculate
partial correlation coefficients}

\item{boot_n}{The number of bootstrap replicates}

\item{boot_ci_type}{A character string representing the type of bootstrap intervals
required. The value should be any subset of the values c("norm","basic", "stud",
"perc", "bca").}

\item{boot_conf_int}{A scalar or vector containing the confidence level(s) of
the required interval(s)}

\item{month_interval}{a vector of two values: lower and upper time interval of
months that will be used to calculate statistical metrics. Negative values indicate
previous growing season months. This argument overwrites the calculation
limits defined by lower_limit and upper_limit arguments.}

\item{dc_method}{a character string to determine the method to detrend climate
(environmental) data.  Possible values are c("Spline", "ModNegExp", "Mean",
"Friedman", "ModHugershoff"). Defaults to "none" (see dplR R package).}

\item{dc_nyrs}{a number giving the rigidity of the smoothing spline, defaults
to 0.67 of series length if nyrs is NULL (see dplR R package).}

\item{dc_f}{a number between 0 and 1 giving the frequency response or wavelength
cutoff. Defaults to 0.5 (see dplR R package).}

\item{dc_pos.slope}{a logical flag. Will allow for a positive slope to be used
in method "ModNegExp" and "ModHugershoff". If FALSE the line will be horizontal
(see dplR R package).}

\item{dc_constrain.nls}{a character string which controls the constraints of
the "ModNegExp" model and the "ModHugershoff"  (see dplR R package).}

\item{dc_span}{a numeric value controlling method "Friedman", or "cv" (default)
for automatic choice by cross-validation (see dplR R package).}

\item{dc_bass}{a numeric value controlling the smoothness of the fitted curve
in method "Friedman" (see dplR R package).}

\item{dc_difference}{a logical flag. Compute residuals by substraction if TRUE,
otherwise use division (see dplR R package).}
}
\value{
a list with 15 elements:
\enumerate{
 \item $calculations - a matrix with calculated metrics
 \item $method - the character string of a method
 \item $metric - the character string indicating the metric used for calculations
 \item $analysed_period - the character string specifying the analysed period based on the information from row names. If there are no row names, this argument is given as NA
 \item $optimized_return - data frame with two columns, response variable and aggregated (averaged) monthly data that return the optimal results. This data.frame could be directly used to calibrate a model for climate reconstruction
 \item $optimized_return_all - a data frame with aggregated monthly data, that returned the optimal result for the entire env_data_primary (and not only subset of analysed years)
 \item $transfer_function - a ggplot object: scatter plot of optimized return and a transfer line of the selected method
 \item $temporal_stability - a data frame with calculations of selected metric for different temporal subsets
 \item $cross_validation - a data frame with cross validation results
 \item $plot_heatmap - ggplot2 object: a heatmap of calculated metrics
 \item $plot_extreme - ggplot2 object: line plot of a row with the highest value in a matrix of calculated metrics
 \item $plot_specific - ggplot2 object: line plot of a row with a selected window width in a matrix of calculated metrics
 \item $PCA_output - princomp object: the result output of the PCA analysis
 \item $type - the character string describing type of analysis: monthly or monthly
 \item $reference_window - character string, which reference window was used for calculations
 \item $aggregated_climate_primary - matrix with all aggregated climate series of primary data
 \item $aggregated_climate_control - matrix with all aggregated climate series of control data
}
}
\description{
Function calculates all possible partial correlation coefficients between
tree-ring chronology and monthly environmental (usually climate) data.
All calculated (partial) correlation coefficients are stored in a matrix.
The location of stored correlation in the matrix is indicating a window
width (row names) and a location in a
matrix of monthly sequences of environmental data (column names).
}
\examples{
\dontrun{
# Load the dendroTools R package
library(dendroTools)

# Load data
data(data_MVA)
data(data_TRW)
data(data_TRW_1)
data(example_proxies_individual)
data(example_proxies_1)
data(LJ_monthly_temperatures)
data(LJ_monthly_precipitation)

# 1 Basic example
example_basic <- monthly_response_seascorr(response = data_MVA,
   fixed_width = 11,
   env_data_primary = LJ_monthly_temperatures,
   env_data_control = LJ_monthly_precipitation,
   row_names_subset = TRUE,
   remove_insignificant = TRUE,
   aggregate_function_env_data_primary = 'median',
   aggregate_function_env_data_control = 'median',
   alpha = 0.05, pcor_method = "spearman",
   tidy_env_data_primary = FALSE,
   tidy_env_data_control = TRUE,
   previous_year = TRUE)

summary(example_basic)
plot(example_basic, type = 1)
plot(example_basic, type = 2)
plot(example_basic, type = 3)
example_basic$optimized_return
example_basic$optimized_return_all


# 2 Extended example
example_extended <- monthly_response_seascorr(response = data_MVA,
   env_data_primary = LJ_monthly_temperatures,
   env_data_control = LJ_monthly_precipitation,
   row_names_subset = TRUE,
   remove_insignificant = TRUE,
   aggregate_function_env_data_primary = 'mean',
   aggregate_function_env_data_control = 'mean',
   alpha = 0.05,
   tidy_env_data_primary = FALSE,
   tidy_env_data_control = TRUE)

summary(example_fixed_width)
plot(example_fixed_width, type = 1)
plot(example_fixed_width, type = 2)
example_fixed_width$optimized_return
example_fixed_width$optimized_return_all

}
}
