% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk4.R
\name{rk4}
\alias{rk4}
\title{Runge Kutta method solution for a differential equation.}
\usage{
rk4(
  system_eq,
  initial_condition,
  parameters = NULL,
  t_start = 0,
  deltaT = 1,
  n_steps = 1
)
}
\arguments{
\item{system_eq}{(REQUIRED) The 1 or 2 dimensional system of equations, written in formula notation as a vector (i.e.  c(dx ~ f(x,y), dy ~ g(x,y)))}

\item{initial_condition}{(REQUIRED) Listing of initial conditions, as a vector}

\item{parameters}{The values of the parameters we are using (optional)}

\item{t_start}{The starting time point (defaults to t = 0)}

\item{deltaT}{The timestep length (defaults to 1)}

\item{n_steps}{The number of timesteps to compute solution (defaults to n_steps = 1)}
}
\value{
A tidy of data frame for the calculated solutions and the time
}
\description{
\code{rk4} solves a multi-dimensional differential equation with Runge-Kutta 4th order method.  The parameters listed as required are needed
See the vignette for detailed examples of usage.
}
\examples{
# Define the rate equation:
quarantine_eq <- c(
 dSdt ~ -k * S * I,
 dIdt ~ k * S * I - beta * I
)
# Define the parameters (as a named vector):
quarantine_parameters <- c(k = .05, beta = .2)
# Define the initial condition (as a named vector):
quarantine_init <- c(S = 300, I = 1)
# Define deltaT and the number of time steps:
deltaT <- .1 # timestep length
n_steps <- 10 # must be a number greater than 1
# Compute the solution via Euler's method:
out_solution <- rk4(system_eq = quarantine_eq,
                   parameters = quarantine_parameters,
                   initial_condition = quarantine_init, deltaT = deltaT,
                   n_steps = n_steps
)
}
\seealso{
See \href{https://en.wikipedia.org/wiki/Runge\%E2\%80\%93Kutta_methods}{Runge Kutta methods} for more explanation of Runge-Kutta methods, as well as the code \code{\link{euler}}
}
