% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{expand}
\alias{expand}
\title{Fitting low-rank nonstationary spatial Gaussian process models through dimension expansion}
\usage{
expand(
  x,
  z,
  n,
  k = 10,
  lambda = rep(-1, length(k)),
  lambda0 = rep(exp(3), length(k)),
  correlation = FALSE,
  cosine = FALSE,
  trace = 0,
  z0 = NULL,
  standardise = "together"
)
}
\arguments{
\item{x}{a 2-column matrix comprising x and y coordinates column-wise, respectively, or a list; see Details for the latter}

\item{z}{a variance-covariance matrix}

\item{n}{an integer number of data}

\item{k}{an integer vector of ranks}

\item{lambda}{specified lambda values}

\item{lambda0}{initial lambda values}

\item{correlation}{a logical defining whether \code{z} should be assumed to be a correlation matrix; defaults to \code{FALSE}}

\item{cosine}{a logical defining whether the powered exponential covariance function should be multiplied by the cosine of scaled distances, i.e. giving a damped oscillation; defaults to \code{FALSE}}

\item{trace}{an integer specifying the amount to report on optimisation (0, default, is nothing; 1 gives a bit)}

\item{z0}{a scalar giving initial values (which alternate \code{z0, -z0, z0, ...} for latent dimensions}

\item{standardise}{a character string that governs whether dimensions are scaled by a common (\code{"together"}) or dimension-specific factor; defaults to \code{"together"}}
}
\value{
An object of class \code{deform} and then of class \code{expansion}
}
\description{
Function \code{exapnd} fits a multi-dimensional dimension expansion model, where typically
x and y coordinates in geographic (G-) space will be provided and then scaled and
combined with new latent dimensions (that a functions of x and y) to give new coordinates 
in deformed (D-) space in which isotropy of a Gaussian process is optimally achieved.
}
\details{
If \code{x} is a list, then it wants elements \code{"x"}, \code{"z"} and \code{"n"} as described above.
}
\examples{

# one-dimensional expansion
data(solar)
expand(solar$x, solar$z, solar$n)
# equivalent to expand(solar)

\donttest{

# two-dimensional expansion with rank-8 and rank-5 dimensions
expand(solar$x, solar$z, solar$n, c(8, 5))

}

}
\references{
Bornn, L., Shaddick, G., & Zidek, J. V. (2012). Modeling nonstationary processes through
dimension expansion. Journal of the American Statistical Association, 107(497), 281-289.
\doi{10.1080/01621459.2011.646919}.
}
