% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_processing.R
\name{layer_generator}
\alias{layer_generator}
\alias{int_processor}
\alias{lin_processor}
\alias{gam_processor}
\title{Function that creates layer for each processor}
\usage{
layer_generator(
  term,
  output_dim,
  param_nr,
  controls,
  layer_class = tf$keras$layers$Dense,
  without_layer = tf$identity,
  name = makelayername(term, param_nr),
  further_layer_args = NULL,
  layer_args_names = NULL,
  units = as.integer(output_dim),
  ...
)

int_processor(term, data, output_dim, param_nr, controls)

lin_processor(term, data, output_dim, param_nr, controls)

gam_processor(term, data, output_dim, param_nr, controls)
}
\arguments{
\item{term}{character; term in the formula}

\item{output_dim}{integer; number of units in the layer}

\item{param_nr}{integer; identifier for models with more 
than one additive predictor}

\item{controls}{list; control arguments which allow
to pass further information}

\item{layer_class}{a tf or keras layer function}

\item{without_layer}{function to be used as 
layer if \code{controls$with_layer} is FALSE}

\item{name}{character; name of layer. 
if NULL, \code{makelayername} will be used to create layer name}

\item{further_layer_args}{named list; further arguments passed to
the layer}

\item{layer_args_names}{character vector; if NULL, default
layer args will be used. Needs to be set for layers that do not
provide the arguments of a default Dense layer.}

\item{units}{integer; number of units for layer}

\item{...}{other keras layer parameters}

\item{data}{data frame; the data used in processors}
}
\value{
a basic processor list structure
}
\description{
Function that creates layer for each processor
}
