% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chance_event.R
\name{chance_event}
\alias{chance_event}
\title{simulate occurrence of random events}
\usage{
chance_event(chance, value_if = 1, value_if_not = 0, n = 1,
  CV_if = 0, CV_if_not = CV_if, one_draw = FALSE)
}
\arguments{
\item{chance}{probability that the risky event will occur (between 0 and 1)}

\item{value_if}{output value in case the event occurs. This can be either a
single numeric value or a numeric vector. Defaults to 1.}

\item{value_if_not}{output value in case the event does not occur. This can
be either a single numeric value or a numeric vector. If it is a vector, it
must have the same length as value_if}

\item{n}{number of times the risky event is simulated. This is ignored if
length(value_if)>1.}

\item{CV_if}{coefficient of variation for introducing randomness into the
value_if data set. This defaults to 0 for no artificial variation. See
documentation for the vv function for details.}

\item{CV_if_not}{coefficient of variation for introducing randomness into
the value_if_not data set. This defaults to the value for CV_if. See
documentation for the vv function for details.}

\item{one_draw}{boolean coefficient indicating if event occurrence is
determined only once (TRUE) with results applying to all elements of the
results vector, or if event occurrence is determined independently for each
element (FALSE; the default)}
}
\value{
numeric vector of the same length as value_if or, if
length(value_if)==1 of length n, containing outputs of a probabilistic
simulation that assigns value_if if the event occurs, or value_if_not if is
does not occur (both optionally with artificial variation)
}
\description{
In many simulations, certain events can either occur or not, and values for
dependent variables can depend on which of the cases occurs. This function
randomly simulates whether events occur and returns output values
accordingly. The outputs can be single values or series of values, with the
option of introducing artificial variation into this dataset.
}
\examples{

chance_event(0.6,6)
 
chance_event(.5,c(0,5),c(5,6))

chance_event(chance=0.5,
             value_if=1,
             value_if_not=5,
             n=10,
             CV_if=20)

}
\author{
Eike Luedeling
}
\keyword{~kwd1}
\keyword{~kwd2}
