% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{remove_outliers}
\alias{remove_outliers}
\title{Analysis Step: Remove outlier droplets}
\usage{
remove_outliers(plate)
}
\arguments{
\item{plate}{A ddPCR plate.}
}
\value{
A ddPCR plate with outlier droplets marked as outliers. The plate's
metadata will have a new variable \code{drops_outlier} which will count the
number of outlier droplets in each well.
}
\description{
Identify droplets that have an abnormally high fluorescence intensity as
outliers. Any such droplets will be assigned to the \emph{OUTLIER} cluster.\cr\cr
\href{https://github.com/daattali/ddpcr#advanced-topic-2-algorithms-used-in-each-step}{See the README} for
more information about the algorithm used to find outlier droplets.
}
\details{
This function is recommended to be run as part of an analysis pipeline (ie.
within the \code{\link[ddpcr]{analyze}} function) rather than being called
directly.
}
\note{
This is an S3 generic, which means that different ddPCR plate types can
implement this function differently. 
\href{https://github.com/daattali/ddpcr#advanced-topic-3-creating-new-plate-types}{See the README} for
more information on how to implement custom ddPCR plate types.
}
\seealso{
\code{\link[ddpcr]{analyze}}\cr
\code{\link[ddpcr]{get_outlier_cutoff}}
}
\keyword{internal}

