% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_daymet_tiles.r
\name{download_daymet_tiles}
\alias{download_daymet_tiles}
\title{Function to batch download gridded 'Daymet' data tiles}
\usage{
download_daymet_tiles(location = c(18.9103, -114.6109), tiles = NULL,
  start = 1980, end = 1980, path = tempdir(), param = "ALL",
  silent = FALSE, force = FALSE)
}
\arguments{
\item{location}{location of a point c(lat, lon) or a bounding box defined
by a top left and bottom-right coordinates c(lat, lon, lat, lon)}

\item{tiles}{which tiles to download, overrides geographic constraints}

\item{start}{start of the range of years over which to download data}

\item{end}{end of the range of years over which to download data}

\item{path}{where should the downloaded tiles be stored (default = tempdir())}

\item{param}{climate variable you want to download vapour pressure (vp), 
minimum and maximum temperature (tmin,tmax), snow water equivalent (swe), 
solar radiation (srad), precipitation (prcp) , day length (dayl).
The default setting is ALL, this will download all the previously mentioned
climate variables.}

\item{silent}{suppress the verbose output}

\item{force}{\code{TRUE} or \code{FALSE} (default),
override the conservative end year setting}
}
\value{
downloads netCDF tiles as defined by the Daymet tile grid
}
\description{
Function to batch download gridded 'Daymet' data tiles
}
\examples{

\dontrun{
Download a single tile of minimum temperature
download_daymet_tiles(location = c(18.9103, -114.6109),
                      start = 1980,
                      end = 1980,
                      param = "tmin")
                      
# For other practical examples consult the included
# vignette. 
}
}
\keyword{climate}
\keyword{data}
\keyword{daymet,}
