% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_erase.R, R/ds_map.R, R/ds_map_bimap.R,
%   R/ds_map_multimap.R
\docType{methods}
\name{erase}
\alias{erase}
\alias{erase,map,vector,missing-method}
\alias{erase,bimap,missing,vector-method}
\alias{erase,multimap,vector,vector-method}
\alias{erase,multimap,vector,list-method}
\alias{erase,multimap,vector,ANY-method}
\title{Erase an entry from a map}
\usage{
erase(obj, key, value)

\S4method{erase}{map,vector,missing}(obj, key)

\S4method{erase}{bimap,missing,vector}(obj, value)

\S4method{erase}{multimap,vector,vector}(obj, key, value)

\S4method{erase}{multimap,vector,list}(obj, key, value)

\S4method{erase}{multimap,vector,ANY}(obj, key, value)
}
\arguments{
\item{obj}{the object to pop an element from}

\item{key}{a vector of keys that should be removed}

\item{value}{optionally a list of values needs to be supplied for some data
structures such as \code{multimap}s if a single key-value pair should removed. If
not provided removes all key-value pairs with a specific key.}
}
\value{
returns \code{obj} with removed values
}
\description{
Erase a vector of key-value pair from a \code{map} object.
}
\examples{

 # erases keys from a hashmap or bimap
 h_map <- hashmap()
 h_map[letters] <- rnorm(length(letters))
 h_map <- erase(h_map, "a")
 h_map <- erase(h_map, letters[2:5])

 # erases keys from a multimap
 m_map <- multimap()
 m_map[c("a", "a", "a", "b", "b", "c")] <- rep(1:2, 3)
 m_map <- erase(m_map, "a")
 m_map <- erase(m_map, "b", 1)

}
