% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sharing.R
\name{ListSharingAccess}
\alias{ListSharingAccess}
\title{List information about which users have what kinds of access to a shared object.}
\usage{
ListSharingAccess(object, batchSize = NULL)
}
\arguments{
\item{object}{object. The shared object to inspect access for.}

\item{batchSize}{integer. The number of requests per page to expect.}
}
\value{
A list specifying information on access:
  \itemize{
     \item username character. The name of the user with access.
     \item userId character. The ID of the user with access.
     \item role character. The type of access granted. See \code{SharingRole} for options.
     \item canShare logical. Whether the user can further share access.
  }
}
\description{
Note that currently only data sources and data stores can be shared with this API.
}
\examples{
\dontrun{
 dataStoreId <- "5c1303269300d900016b41a7"
 dataStore <- GetDataStore(dataStoreId)
 ListSharingAccess(dataStore)
}
}
