% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainingPredictions.R
\name{GetTrainingPredictionsForModel}
\alias{GetTrainingPredictionsForModel}
\title{Get training predictions for a particular model.}
\usage{
GetTrainingPredictionsForModel(model, dataSubset = "all",
  maxWait = 600)
}
\arguments{
\item{model}{dataRobotModel. The model to get training predictions for.}

\item{dataSubset}{character. What data subset would you like to predict on?
Possible options are included in \code{DataSubset}. Possible options are:
\itemize{
  \item \code{DataSubset$All} will use all available data.
  \item \code{DataSubset$ValidationAndHoldout} will use all data except the
    training set.
  \item \code{DataSubset$Holdout} will use only holdout data.
}}

\item{maxWait}{integer. The maximum time (in seconds) to wait for the model job to complete.}
}
\description{
Training predictions are the internal out-of-fold predictions for data that was
used to train the model. These predictions are especially useful for creating
stacked models or blenders.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  trainingPredictions <- GetTrainingPredictionsFromModel(model)
}
}
