/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Polyadic;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.List;
import java.util.Map;

public class PolyadicPrefixMappingImpl
extends PrefixMappingImpl
implements PrefixMapping {
    private Polyadic poly;
    private PrefixMapping pending = new PrefixMappingImpl();

    public PolyadicPrefixMappingImpl(Polyadic p) {
        this.poly = p;
    }

    protected boolean equals(PrefixMappingImpl other) {
        return this.equalsByMap(other);
    }

    protected boolean sameAs(PrefixMappingImpl other) {
        return this.equalsByMap(other);
    }

    private PrefixMapping getBaseMapping() {
        Graph base = this.poly.getBaseGraph();
        return base == null ? this.pending : base.getPrefixMapping();
    }

    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.checkUnlocked();
        this.getBaseMapping().setNsPrefix(prefix, uri);
        return this;
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        this.checkUnlocked();
        this.getBaseMapping().removeNsPrefix(prefix);
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.setNsPrefixes(other.getNsPrefixMap());
    }

    public PrefixMapping setNsPrefixes(Map other) {
        this.checkUnlocked();
        this.getBaseMapping().setNsPrefixes(other);
        return this;
    }

    public String getNsPrefixURI(String prefix) {
        PrefixMapping bm = this.getBaseMapping();
        String s = bm.getNsPrefixURI(prefix);
        if (s == null && prefix.length() > 0) {
            List graphs = this.poly.getSubGraphs();
            for (int i = 0; i < graphs.size(); ++i) {
                String ss = ((Graph)graphs.get(i)).getPrefixMapping().getNsPrefixURI(prefix);
                if (ss == null) continue;
                return ss;
            }
        }
        return s;
    }

    public Map getNsPrefixMap() {
        Map result = CollectionFactory.createHashedMap();
        List graphs = this.poly.getSubGraphs();
        for (int i = 0; i < graphs.size(); ++i) {
            result.putAll(((Graph)graphs.get(i)).getPrefixMapping().getNsPrefixMap());
        }
        result.putAll(this.getBaseMapping().getNsPrefixMap());
        return result;
    }

    public String getNsURIPrefix(String uri) {
        String s = this.getBaseMapping().getNsURIPrefix(uri);
        if (s == null) {
            List graphs = this.poly.getSubGraphs();
            for (int i = 0; i < graphs.size(); ++i) {
                String ss = ((Graph)graphs.get(i)).getPrefixMapping().getNsURIPrefix(uri);
                if (ss == null || ss.length() <= 0) continue;
                return ss;
            }
        }
        return s;
    }

    public String expandPrefix(String prefixed) {
        String s = this.getBaseMapping().expandPrefix(prefixed);
        if (s.equals(prefixed)) {
            List graphs = this.poly.getSubGraphs();
            for (int i = 0; i < graphs.size(); ++i) {
                String ss = ((Graph)graphs.get(i)).getPrefixMapping().expandPrefix(prefixed);
                if (ss.equals(prefixed)) continue;
                return ss;
            }
        }
        return s;
    }

    public String toString() {
        return "<polyadic prefix map>";
    }

    public String shortForm(String uri) {
        String s = this.getBaseMapping().shortForm(uri);
        if (s.equals(uri)) {
            List graphs = this.poly.getSubGraphs();
            for (int i = 0; i < graphs.size(); ++i) {
                String ss = ((Graph)graphs.get(i)).getPrefixMapping().shortForm(uri);
                if (ss.equals(uri)) continue;
                return ss;
            }
        }
        return s;
    }

    public String qnameFor(String uri) {
        String result = this.getBaseMapping().qnameFor(uri);
        if (result == null) {
            List graphs = this.poly.getSubGraphs();
            for (int i = 0; i < graphs.size(); ++i) {
                String ss = ((Graph)graphs.get(i)).getPrefixMapping().qnameFor(uri);
                if (ss == null) continue;
                return ss;
            }
        }
        return result;
    }
}

