% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class_def.R
\docType{class}
\name{ga_fsm-class}
\alias{action_vec,ga_fsm-method}
\alias{barplot,ga_fsm-method}
\alias{best_performance,ga_fsm-method}
\alias{dotchart,ga_fsm-method}
\alias{estimation_details,ga_fsm-method}
\alias{ga_fsm-class}
\alias{plot,ga_fsm,ANY-method}
\alias{plot,ga_fsm-method}
\alias{predict,ga_fsm-method}
\alias{print,ga_fsm-method}
\alias{show,ga_fsm-method}
\alias{states,ga_fsm-method}
\alias{summary,ga_fsm-method}
\alias{varImp,ga_fsm-method}
\title{An S4 class to return the results of using a GA to estimate a FSM with
\code{\link{evolve_model}}.}
\usage{
\S4method{print}{ga_fsm}(x, ...)

\S4method{show}{ga_fsm}(object)

\S4method{summary}{ga_fsm}(object, digits = 3)

\S4method{plot}{ga_fsm,ANY}(x, y, maintitle = "Transition Diagram",
  action_label = NULL, transition_label = NULL, curvature = c(0.3, 0.6,
  0.8))

\S4method{barplot}{ga_fsm}(height, ...)

\S4method{dotchart}{ga_fsm}(x, labels)

\S4method{estimation_details}{ga_fsm}(x)

\S4method{best_performance}{ga_fsm}(x)

\S4method{varImp}{ga_fsm}(x)

\S4method{action_vec}{ga_fsm}(x)

\S4method{states}{ga_fsm}(x)

\S4method{predict}{ga_fsm}(object, data, type = "prob",
  na.action = stats::na.omit, ...)
}
\arguments{
\item{x}{S4 ga_fsm object.}

\item{...}{arguments to be passed to/from other methods.}

\item{object}{S4 ga_fsm object}

\item{digits}{Optional numeric vector length one for how many significant digits to
print, default is 3.}

\item{y}{not used.}

\item{maintitle}{optional character vector}

\item{action_label}{optional character vector same length as action vector,
where each ith element corresponds to what that ith element in the action
vector represents. This will be used to fill in the states (circles) of the
state transition matrix to be plotted.}

\item{transition_label}{optional character vector same length as number of
columns of state transition matrix.}

\item{curvature}{optional numeric vector specifying the curvature of the
  lines for a diagram of 2 or more states.}

\item{height}{ga_fsm S4 object}

\item{labels}{vector of labels for each point. For vectors the default is to
use names(x) and for matrices the row labels dimnames(x)[[1]].}

\item{data}{data.frame that has columns named "period" and "outcome" (period
is the time period that the outcome action was taken), and the rest of the
columns are predictors, ranging from one to three predictors. All of the
(3-5 columns) should be named. The period and outcome columns should be
integer vectors and the columns with the predictor variable data should be
logical vectors (\code{TRUE, FALSE}). If the predictor variable data is not
logical, it will coerced to logical with \code{base::as.logical()}.}

\item{type}{Not currently used.}

\item{na.action}{Optional function.}
}
\description{
An S4 class to return the results of using a GA to estimate a FSM with
\code{\link{evolve_model}}.

Turns ga_fsm S4 object into list of summaries for printing and then prints it.

Plots ga_fsm S4 object's state transition matrix

Plots ga_fsm S4 object's variable importances

Plots ga_fsm S4 object's variable importances

Extracts slot relevant to estimating the fsm

Extracts performance

Extracts slot of variable importances

Extracts slot of action_vec

Extracts number of states
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: An S4 method for printing a ga_fsm S4 object

\item \code{show}: An S4 method for showing a ga_fsm S4 object

\item \code{summary}: An S4 method for summarizing a ga_fsm S4 object

\item \code{plot}: 

\item \code{barplot}: 

\item \code{dotchart}: 

\item \code{estimation_details}: 

\item \code{best_performance}: 

\item \code{varImp}: 

\item \code{action_vec}: 

\item \code{states}: 

\item \code{predict}: 
}}
\section{Slots}{

\describe{
\item{\code{call}}{Language from the call of the function \code{\link{evolve_model}}.}

\item{\code{actions}}{Numeric vector with the number of actions.}

\item{\code{states}}{Numeric vector with the number of states.}

\item{\code{GA}}{S4 object created by ga() from the GA package.}

\item{\code{state_mat}}{Numeric matrix with rows as states and columns as predictors.}

\item{\code{action_vec}}{Numeric vector indicating what action to take for each
state.}

\item{\code{predictive}}{Numeric vector of length one with test data accuracy if test
data was supplied; otherwise, a character vector with a message that the
user should provide test data for better estimate of performance.}

\item{\code{varImp}}{Numeric vector same length as number of columns of state matrix
with relative importance scores for each predictor.}

\item{\code{timing}}{Numeric vector length one with the total elapsed seconds it took
\code{\link{evolve_model}} to execute.}

\item{\code{diagnostics}}{Character vector length one, to be printed with base::cat().}
}}

