% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_session_assets_fr_df.R
\name{download_session_assets_fr_df}
\alias{download_session_assets_fr_df}
\title{Download Asset From A Databrary Session.}
\usage{
download_session_assets_fr_df(
  session_df = list_session_assets(),
  target_dir = tempdir(),
  overwrite = TRUE,
  make_portable_fn = FALSE,
  timeout_secs = 600,
  vb = FALSE,
  rq = NULL
)
}
\arguments{
\item{session_df}{A data frame as generated by list_session_assets_2().}

\item{target_dir}{A character string. Directory to save the downloaded file.
Default is directory named after the session_id.}

\item{overwrite}{A logical value. Overwrite an existing file. Default is TRUE.}

\item{make_portable_fn}{A logical value. Replace characters in file names
that are not broadly portable across file systems. Default is FALSE.}

\item{timeout_secs}{An integer. The seconds an httr2 request will run before
timing out. Default is 600 (10 min). This is to handle very large files.}

\item{vb}{A logical value. If TRUE provides verbose output. Default is FALSE.}

\item{rq}{A list in the form of an \code{httr2} request object. Default is NULL.}
}
\value{
Full file names to the downloaded assets or NULL.
}
\description{
Databrary stores file types (assets) of many types. This
function downloads assets in a data frame generated by list_session_assets().
}
\examples{
\donttest{
\dontrun{
download_session_assets_fr_df() # Downloads all of the files from session
9807 in Databrary volume 1.

# Just the CSVs
v1 <- list_session_assets()
v1_csv <- dplyr::filter(v1, format_extension == "csv")
download_session_assets_fr_df(v1_csv, vb = TRUE)
}
}
}
