% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GET_db_contents.R
\name{GET_db_contents}
\alias{GET_db_contents}
\title{Queries the Databrary API with an HTML GET command}
\usage{
GET_db_contents(
  base_URL = "https://nyu.databrary.org",
  URL_components = "/api/volume/1",
  convert_JSON = TRUE,
  vb = FALSE
)
}
\arguments{
\item{base_URL}{Base URL for API call. Default is https://nyu.databrary.org.}

\item{URL_components}{Other components of API URL usually assembled using a paste0() command.}

\item{convert_JSON}{A Boolean value. If TRUE, convert JSON to a data frame. Default is TRUE.}

\item{vb}{A Boolean value. If TRUE provides verbose output.}
}
\value{
Output from GET command with the specified parameters, usually a string or a data frame.
}
\description{
\code{GET_db_contents} is a helper function that retrieves
information from the 'Databrary.org' API in a structured way.
}
\examples{
\donttest{
GET_db_contents() # Returns a list with data from volume 1.
#' }
}
