% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_from_factor.R
\name{compute_weight_of_evidence}
\alias{compute_weight_of_evidence}
\title{Compute weight of evidence}
\usage{
compute_weight_of_evidence(x)
}
\arguments{
\item{x}{A \code{list} of categorical elements}
}
\value{
Weight of evidence
}
\description{
Weight of evidence is an aggregation function that can be used for 
\code{build_target_encoding}. Weight of evidence is the ln(P(most freq element) / (1 - P(most frq element))).
}
\details{
To be more generic, the library compute P(most freq element) inplace of traditional formula ln(P(1)/P(0))
}
\examples{
# Build example list
example_list <- c(1, 1, 1, 2, 2, 3)

# Compute weight of evidence
compute_weight_of_evidence(example_list)
}
