% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setColAs.R
\name{setColAsNumeric}
\alias{setColAsNumeric}
\title{Set columns as numeric}
\usage{
setColAsNumeric(dataSet, cols, stripString = FALSE, verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{cols}{list of column(s) name(s) of dataSet to transform into numerics}

\item{stripString}{should I change "," to "." in the string? (logical, default to FALSE) 
If set to TRUE, computation will be a bit longer}

\item{verbose}{should the function log (logical, default to TRUE)}
}
\value{
dataSet (as a \code{\link{data.table}}), with specified columns set as numeric.
}
\description{
Set as numeric a character column (or a list of columns) from a data.table
}
\examples{
# Build a fake data.table
dataSet <- data.frame(charCol1 = c("1", "2", "3"), 
						 charCol2 = c("4", "5", "6"))

# Set charCol1 and charCol2 as numeric
dataSet <- setColAsNumeric(dataSet, cols = c("charCol1", "charCol2"))

# Using strip string when spaces or wrong decimal separator is used
dataSet <- data.frame(charCol1 = c("1", "2", "3"), 
                      charCol2 = c("4, 1", "5, 2", "6, 3"))

# Set charCol1 and charCol2 as numeric
setColAsNumeric(dataSet, cols = c("charCol1", "charCol2")) 
# generate mistakes
setColAsNumeric(dataSet, cols = c("charCol1", "charCol2"), stripString = TRUE) 
# Doesn't generate any mistake (but is a bit slower)
}
