% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastFunctions.r
\name{fastIsEqual}
\alias{fastIsEqual}
\title{Fast checks of equality}
\usage{
fastIsEqual(object1, object2)
}
\arguments{
\item{object1}{an element, a vector, a data.frame, a data.table}

\item{object2}{an element, a vector, a data.frame, a data.table}
}
\value{
Logical (TRUE or FALSE) if the two objects are equals.
}
\description{
Performs quick check if two objects are equal
}
\details{
This function is fast for very large vectors, data.frame and data.table. 
This function is also very robust; you can compare a lot of stuff without failing.
}
\examples{
# Test on a character
fastIsEqual("a", "a")
fastIsEqual("a", "b")

# Test on a vector
myVector <- rep(x = "a", 10000)
fastIsEqual(myVector, myVector)

# Test on a data.table
fastIsEqual(messy_adult, messy_adult)
}
