% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_methods.R
\name{Navigate}
\alias{Navigate}
\title{Navigate to another node by relative path.}
\usage{
Navigate(node, path)
}
\arguments{
\item{node}{The starting \code{\link{Node}} to navigate}

\item{path}{A string or a character vector describing the path to navigate}
}
\description{
Navigate to another node by relative path.
}
\details{
The \code{path} is always relative to the \code{node}. Navigation
to the parent is defined by \code{..}, whereas navigation to a child
is defined via the child's name.
If path is provided as a string, then the navigation steps are separated
by '/'.
}
\examples{
data(acme)
Navigate(acme$Research, "../IT/Outsource")
Navigate(acme$Research, c("..", "IT", "Outsource"))

}
\seealso{
\code{\link{Climb}}
}

