% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.R
\docType{methods}
\name{replace}
\alias{replace}
\alias{replace,list,function-method}
\alias{replace,atomic,function-method}
\alias{replace,atomicORlist,integerORnumericORlogical-method}
\alias{replace,ANY,formula-method}
\alias{replace,ANY,character-method}
\title{Replace elements in a vector}
\usage{
replace(x, ind, values, ...)

\S4method{replace}{list,`function`}(x, ind, values, ...)

\S4method{replace}{atomic,`function`}(x, ind, values, ...)

\S4method{replace}{atomicORlist,integerORnumericORlogical}(x, ind, values, ...)

\S4method{replace}{ANY,formula}(x, ind, values, ...)

\S4method{replace}{ANY,character}(x, ind, values, ...)
}
\arguments{
\item{x}{(atomic | list) a vector.}

\item{ind}{used as index for elements to be replaced. See details.}

\item{values}{the values used for replacement.}

\item{...}{arguments passed to \code{ind} if it can be interpreted as
function. For a regex arguments are passed to \link{grep}.}
}
\description{
This function replaces elements in a vector. It is a link to
\link[base]{replace} as a generic function.
}
\details{
The idea is to provide a more felxible interface for the
  specification of the index. It can be a character, numeric, integer or
  logical which is then simply used in \code{base::replace}. It can be a
  regular expression in which case \code{x} should be named -- a character of
  length 1 and a leading "^" is interpreted as regex. When \code{ind} is a
  function (or formula) and \code{x} is a list then it should be a predicate
  function -- see the examples. When x is an atomic the function is applied
  on x and the result is used for subsetting.
}
\examples{
replace(c(1, 2, NA), is.na, 0)
replace(c(1, 2, NA), rep(TRUE, 3), 0)
replace(c(1, 2, NA), 3, 0)
replace(list(x = 1, y = 2), "x", 0)
replace(list(x = 1, y = 2), "^x$", 0)
replace(list(x = 1, y = "a"), is.character, NULL)
}
