% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dalmatian.R
\name{plot.dalmatian}
\alias{plot.dalmatian}
\title{Plot Function for \code{dalmatian} objects}
\usage{
\method{plot}{dalmatian}(
  x,
  trace = TRUE,
  caterpillar = TRUE,
  show = TRUE,
  return_plots = FALSE,
  ...
)
}
\arguments{
\item{x}{Object of class \code{dalmatian} created by \code{dalmatian()}.}

\item{trace}{If TRUE (default) then generate traceplots.}

\item{caterpillar}{If TRUE (default) then generate caterpillar plots}

\item{show}{If TRUE (default) then display plots as they are generated.}

\item{return_plots}{If TRUE (not default) return a list of \code{ggplot} objects representing the plots.}

\item{...}{Ignored}
}
\value{
List of \code{ggplot} objects if \code{return_plots} is true.
}
\description{
Create traceplots and caterpillar plots from output of the fitted model.
}
\details{
This function is a wrapper for the functions \code{traceplots.dalmatian()} and \code{caterpillar.dalmatian()} which
create traceplots and caterpillar plots of all variables stored by the sampler. Further control is available by calling
these functions directly.
}
\examples{
\dontrun{
## Plot results for pied-flycatcher model without random effects
plot(pfresults)

## Plot results for pied-flycatcher model with random effects
plot(pfresults2)
}
}
\references{
Bonner, S., Kim, H., Westneat, D., Mutzel, A.,
Wright, J., and Schofield, M.. (2021). \code{dalmatian}: A Package
for Fitting Double Hierarchical Linear Models in \code{R} via \code{JAGS} and
\code{nimble}. \emph{Journal of Statistical Software}, 100, 10, 1--25.
\doi{10.18637/jss.v100.i10}.
}
\author{
Simon Bonner
}
