% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.r
\name{isCollider}
\alias{isCollider}
\title{Test for Colliders}
\usage{
isCollider(x, u, v, w)
}
\arguments{
\item{x}{the input graph, a DAG.}

\item{u}{the first endpoint of the putative collider}

\item{v}{the midpoint of the putative collider}

\item{w}{the second endpoint of the putative collider}
}
\description{
Returns \code{TRUE} if three given variables form a collider in a given graph.
}
\examples{
g1 <- dagitty("dag{X -> Y -> Z}")
stopifnot( isTRUE(!isCollider( g1, "X", "Y", "Z" )) )
g2 <- dagitty("dag{X -> Y <- Z }")
stopifnot( isTRUE(isCollider( g2, "X", "Y", "Z" )) )
}
