% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/LV_project_alpha_pairwise_lambdacov_global_alphacov_pairwise.R
\name{LV_project_alpha_pairwise_lambdacov_global_alphacov_pairwise}
\alias{LV_project_alpha_pairwise_lambdacov_global_alphacov_pairwise}
\title{Lotka-Volterra model for projecting abundances,
with specific alpha values and global covariate effects on alpha and lambda}
\usage{
LV_project_alpha_pairwise_lambdacov_global_alphacov_pairwise(
  lambda,
  alpha_intra,
  alpha_inter,
  lambda_cov,
  alpha_cov,
  abundance,
  covariates
)
}
\arguments{
\item{lambda}{named numeric lambda value.}

\item{alpha_intra}{single numeric value.}

\item{alpha_inter}{numeric vector with interspecific alpha values.}

\item{lambda_cov}{numeric vector with effects of covariates over lambda.}

\item{alpha_cov}{named list of named numeric vectors 
with effects of each covariate over alpha values.}

\item{abundance}{named numeric vector of abundances in the previous timestep.}

\item{covariates}{matrix with observations in rows and covariates in named columns. 
Each cell is the value of a covariate in a given observation.}
}
\value{
numeric abundance projected one timestep
}
\description{
Lotka-Volterra model for projecting abundances,
with specific alpha values and global covariate effects on alpha and lambda
}
