% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curlconverter.r
\name{straighten}
\alias{straighten}
\title{Processes cURL command-line requests}
\usage{
straighten(curls = read_clip(), quiet = FALSE)
}
\arguments{
\item{curls}{a character vector of one or more cURL command lines. It will
read from the clipboard (i.e. if you did a \emph{"Copy as cURL"} from
browser developer tools).}

\item{quiet}{if \code{FALSE}, a \code{message} with the original \code{cURL}
command line will be output. (Default: \code{FALSE})}
}
\value{
\code{list} of \code{length(curls)} containing parsed data (i.e. to be used
         in `httr` requests)
}
\description{
Takes in a \emph{"Copy as cURL"} command line and returns a \code{list} of
components that can be used to build \code{httr} requests or passed to
\code{\link{make_req}()} to automagically make an \code{httr}
\code{\link[httr]{VERB}()} function.
}
\examples{
library(httr)

my_ip <- straighten("curl 'https://httpbin.org/ip'") \%>\% make_req()

\dontrun{
# external test which captures live data
content(my_ip[[1]](), as="parsed")
}
}
\references{
\href{https://developer.chrome.com/devtools/docs/network}{Evaluating Network Performance},
            \href{https://developer.mozilla.org/en-US/docs/Tools/Network_Monitor}{Network Monitor}
}
\seealso{
\code{\link{make_req}()}, \code{httr} \code{\link[httr]{VERB}()}
}

