% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_proj.R
\name{cuml_rand_proj}
\alias{cuml_rand_proj}
\title{Random projection for dimensionality reduction.}
\usage{
cuml_rand_proj(
  x,
  n_components = NULL,
  eps = 0.1,
  gaussian_method = TRUE,
  density = NULL,
  transform_input = TRUE,
  seed = 0L
)
}
\arguments{
\item{x}{The input matrix or dataframe. Each data point should be a row
and should consist of numeric values only.}

\item{n_components}{Dimensionality of the target projection space. If NULL,
then the parameter is deducted using the Johnson-Lindenstrauss lemma,
taking into consideration the number of samples and the \code{eps}
parameter. Default: NULL.}

\item{eps}{Error tolerance during projection. Default: 0.1.}

\item{gaussian_method}{If TRUE, then use the Gaussian random projection
method. Otherwise, use the sparse random projection method.
See https://en.wikipedia.org/wiki/Random_projection for details.
Default: TRUE.}

\item{density}{Ratio of non-zero component in the random projection matrix.
If NULL, then the value is set to the minimum density as recommended by
Ping Li et al.: 1 / sqrt(n_features). Default: NULL.}

\item{transform_input}{Whether to project input data onto a lower dimension
space using the random matrix. Default: TRUE.}

\item{seed}{Seed for the pseudorandom number generator. Default: 0L.}
}
\value{
A context object containing GPU pointer to a random matrix that can
  be used as input to the \code{cuml_transform()} function.
  If \code{transform_input} is set to TRUE, then the context object will also
  contain a "transformed_data" attribute containing the lower dimensional
  projection of the input data.
}
\description{
Generate a random projection matrix for dimensionality reduction, and
optionally transform input data to a projection in a lower dimension space
using the generated random matrix.
}
\examples{
library(cuml)
library(mlbench)

data(Vehicle)
vehicle_data <- Vehicle[order(Vehicle$Class), which(names(Vehicle) != "Class")]

ctx <- cuml_rand_proj(vehicle_data, n_components = 4)

set.seed(0L)
print(kmeans(ctx$transformed_data, centers = 4, iter.max = 1000))
}
