% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/positivity_test.R
\name{positivity_test}
\alias{positivity_test}
\title{Computes a p-value of ctDNA positivity with a Monte-Carlo based sampling test}
\usage{
positivity_test(depths, alt_reads, rate, seed = 123,
  n_simulations = 10000)
}
\arguments{
\item{depths}{a vector with the depths of the variants}

\item{alt_reads}{the observed variant allele reads}

\item{rate}{A named list containing mismatch rates as produced by get_background_rate function}

\item{seed}{the random seed}

\item{n_simulations}{the number of simulations to run.}
}
\value{
a scalar, simulation p-value.
}
\description{
A function to determine ctDNA positivity with N repeated Monte Carlo simulations. Return a p-value based on Monte Carlo simulation test. Calls simulator function  n_simulations times.
}
\seealso{
\code{\link{test_ctDNA}}
}
\keyword{internal}
