% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_trinucleotide_context.R
\name{extract_trinucleotide_context}
\alias{extract_trinucleotide_context}
\title{Extracts the trinucleotide context for a set of mutations}
\usage{
extract_trinucleotide_context(mutations, reference, destrand = TRUE)
}
\arguments{
\item{mutations}{A data frame having the mutations. Should have the columns CHROM, POS, REF, ALT.}

\item{reference}{the reference genome in BSgenome format}

\item{destrand}{logical, whether to destrand mutations}
}
\value{
A data frame with two columns having the substitutions and the trinucleotide context
}
\description{
Extracts the trinucleotide context for a set of mutations
}
\examples{
\donttest{
data("mutations", package = "ctDNAtools")
## Use human reference genome from BSgenome.Hsapiens.UCSC.hg19 library
suppressMessages(library(BSgenome.Hsapiens.UCSC.hg19))

## with destranding
extract_trinucleotide_context(mutations, BSgenome.Hsapiens.UCSC.hg19)

## without destranding
extract_trinucleotide_context(mutations, BSgenome.Hsapiens.UCSC.hg19,
  destrand = FALSE
)
}
}
