% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_info.R
\name{crypto_info}
\alias{crypto_info}
\title{Retrieves info (urls, logo, description, tags, platform, date_added, notice, status) on CMC for given id or slug}
\usage{
crypto_info(coin_list = NULL, limit = NULL)
}
\arguments{
\item{coin_list}{string if NULL retrieve all currently active coins (\code{crypto_list()}),
or provide list of cryptocurrencies in the \code{crypto_list()} format (e.g. current and/or dead coins since 2015)}

\item{limit}{integer Return the top n records, default is all tokens}
}
\value{
List of (active and historically existing) cryptocurrencies in a tibble:
\item{id}{CMC id (unique identifier)}
\item{name}{Coin name}
\item{symbol}{Coin symbol (not-unique)}
\item{slug}{Coin URL slug (unique)}
\item{category}{Coin category: "token" or "coin"}
\item{description}{Coin description according to CMC}
\item{logo}{CMC url of CC logo}
\item{subreddit}{Name of subreddit community}
\item{notice}{Markdown formatted notices from CMC}
\item{date_added}{Date CC was added to the CMC database}
\item{twitter_username}{Username of CCs twitter account}
\item{is_hidden}{TBD}
\item{date_launched}{Date CC was launched}
\item{self_reported_circulating_supply}{Self reported circulating supply}
\item{self reported tags}{Self_reported_tags}
\item{status}{timestamp and other status messages}
\item{tags}{Tibble of tags and tag categories}
\item{url}{Tibble of various resource urls. Gives website, technical_doc (whitepaper),
source_code, message_board, chat, announcement, reddit, twitter, (block) explorer urls}
\item{Platform}{Metadata about the parent coin if available. Gives id, name, symbol,
slug, and token address according to CMC}
}
\description{
This code uses the web api. It retrieves data for all active, delisted and untracked coins! It does not require an 'API' key.
}
\examples{
\dontrun{
# return info for bitcoin
coin_info <- crypto_info(limit=3)
}

}
