% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getExchanges.R
\name{getExchanges}
\alias{getExchanges}
\title{Get current crypto market exchanges}
\usage{
getExchanges(coin = NULL, limit = NULL, cpu_cores = NULL,
  start_date = NULL, end_date = NULL)
}
\arguments{
\item{coin}{string Name, symbol or slug of crypto currency, default is all tokens}

\item{limit}{integer Return the top n records, default is all tokens}

\item{cpu_cores}{integer Uses n cores for processing, default uses all cores}

\item{start_date}{string Start date to retrieve data from, format 'yyyymmdd'}

\item{end_date}{string End date to retrieve data from, format 'yyyymmdd'}

\item{...}{No arguments, return all coins}
}
\value{
Crypto currency historic OHLC market data in a dataframe:
  \item{slug}{Coin url slug}
  \item{symbol}{Coin symbol}
  \item{name}{Coin name}
  \item{trading_pair}{Coin trading pair}
  \item{exchange_name}{Name of exchange}
  \item{last_updated}{Exchange refresh}
  \item{exchange_volume}{Exchange $USD volume}
  \item{exchange_price}{Exchange $USD price}
  \item{exchange_share}{Percent exchange traded}
  \item{coin_rank}{Rank of current coin}
  \item{exchange_rank}{Exchange ranking for coin}
If you want to retrieve ALL coins and their exchanges,
then do not pass a argument to getExchanges(),


Please note that the doSNOW package is required to load the progress bar on
both linux and macOS systems as the doParallel package does not support it.
}
\description{
Scrape the crypto currency exchange tables from
CoinMarketCap <https://coinmarketcap.com> and display
the results in a date frame. This can be used to conduct
analysis on the exchanges or to attempt
to predict exchange arbiture.
}
\examples{
\dontrun{
# Retrieving exchange data for specific crypto currency

coin <- "kin"
kin_exchanges <- getExchanges(coin)

# retrieving market history for ALL crypto currencies

all_exchanges <- getExchanges()

}
}
