% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{autoplot}
\alias{autoplot}
\alias{autoplot.DatetimeVariable}
\alias{autoplot.NumericVariable}
\alias{autoplot.CategoricalVariable}
\alias{autoplot.CategoricalArrayVariable}
\alias{autoplot.MultipleResponseVariable}
\alias{autoplot.CrunchCube}
\alias{autoplot.CrunchCubeCalculation}
\alias{autoplot.tbl_crunch_cube}
\title{Autoplot methods for Crunch Objects}
\usage{
\method{autoplot}{DatetimeVariable}(x, ...)

\method{autoplot}{NumericVariable}(x, ...)

\method{autoplot}{CategoricalVariable}(x, ...)

\method{autoplot}{CategoricalArrayVariable}(x, ...)

\method{autoplot}{MultipleResponseVariable}(x, ...)

\method{autoplot}{CrunchCube}(x, ...)

\method{autoplot}{CrunchCubeCalculation}(x, plot_type = "dot", ...)

\method{autoplot}{tbl_crunch_cube}(x, plot_type = c("dot", "tile", "bar"), measure)
}
\arguments{
\item{x}{A Crunch variable or cube aggregation}

\item{...}{additional plotting arguments}

\item{plot_type}{One of \code{"dot"}, \code{"tile"}, or \code{"bar"} which indicates the
plot family you would like to use. Higher dimensional plots add color
coding or facets depending on the dimensionality of the data.}

\item{measure}{The measure you wish to plot. This will usually be \code{"count"},
the default but can also be \code{".unweighted_counts"} or any other measure
stored in the cube. If omitted, autoplot will select the first measure
appearing in the data.}
}
\value{
A \code{ggplot} object.
}
\description{
The Crunch autoplot methods generate \code{ggplots} that are tailored to various
Crunch objects. This allows you to visualize the object without bringing it
into memory. You can select between three families of plots, which will
attempt to accomodate the dimensionality of the plotted object. These plots
can be further extended and customized with other ggplot methods.
}
