% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_multi_silodata.R
\name{get_multi_silodata}
\alias{get_multi_silodata}
\title{Retrieve SILO data for multiple sites from Qld DES longpaddock website}
\usage{
get_multi_silodata(
  latitude,
  longitude,
  Sitename,
  email,
  START = "20201101",
  FINISH = "20201231",
  FORMAT = "APSIM",
  PASSWORD = "apitest",
  URL = "https://www.longpaddock.qld.gov.au/cgi-bin/silo/DataDrillDataset.php"
)
}
\arguments{
\item{latitude}{A numerical vector containing site latitudes for
data retrieval}

\item{longitude}{A numerical vector containing site longitudes for
data retrieval}

\item{Sitename}{A vector of strings containing site names or
labels which provide an extra column in the dataset named
\code{Sitename}}

\item{email}{A string containing your email which is required by
DES in order to access the data}

\item{START}{Start date as a character string \dQuote{YYYYMMDD}
with no spaces. Default: \dQuote{20201101}}

\item{FINISH}{Last date as a character string \dQuote{YYYYMMDD}
with no spaces. Default: \dQuote{20201231}}

\item{FORMAT}{of data file required. While this function was
originally constructed to obtain \code{APSIM} format, other
formats are available. See
\url{https://www.longpaddock.qld.gov.au/silo/about/file-formats-and-samples/}
Default: \dQuote{APSIM}}

\item{PASSWORD}{Default: \dQuote{apitest}}

\item{URL}{is the URL for querying the website and probably will
not need to be changed. Default:
\dQuote{https://www.longpaddock.qld.gov.au/cgi-bin/silo/DataDrillDataset.php}}
}
\value{
A \code{\link{tibble}} (dataframe) containing specified or
default climate variables. If \dQuote{APSIM} format is specified
then an extra column \code{date_met}, containing the date, is
returned along with the usual \code{year} and day of year
\code{day}. The \code{Sitename} variable contains the name of
each site.
}
\description{
Uses \code{\link{get_silodata}} to retrieve SILO (Scientific
Information for Land Owners) data for multiple sites. SILO
products are provided free of charge to the public for use under
the Creative Commons Attribution 4.0 license and appear to be
subject to fair use limits. Note that SILO may be unavailable
between 11am and 1pm (Brisbane time) each Wednesday and Thursday
to allow for essential system maintenance.
}
\examples{
\dontrun{
## Example: Replace MY_EMAIL_ADDRESS with your email address below
two_sites  <-
  get_multi_silodata(latitude = c(-27.00, -28.00),
                     longitude = c(151.00, 152.00),
                     Sitename = c("Site_1", "Site_2"),
                     START = "20201101", FINISH = "20201105",
                     email = "MY_EMAIL_ADDRESS")
two_sites
}

}
\seealso{
\code{\link{get_silodata}}
}
