% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ccrop_zoning.R
\name{plot_ccrop_zoning}
\alias{plot_ccrop_zoning}
\title{Function to plot the climate crop zoning stack  generated in ccrop_zoning}
\usage{
plot_ccrop_zoning(zoning)
}
\arguments{
\item{zoning}{A stack generated in ccrop_zoning}
}
\value{
Returns a plot (ggplot object) with the monthly climate crop zoning based in air temperature.
}
\description{
This function will plot the ccrop_zoning output. The result of the plotting
will generate a plot with the following classes.

  Climatic zoning classes:
\itemize{
  \item  ST: Suitable air temperature
  \item RLT: Restricted due to low temperature 
  \item RHT: Restricted due to high temperature 
  \item ULT: Unsuitable due to low temperature 
  \item UHT: Unsuitable due to high temperature 
}
}
\examples{
### Data preparation
\dontrun{
###ploting the cropzoning:

zoning_plot <- plot_ccrop_zoning(zoning)
}
}
