% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/caseUtils.R
\name{getDateTime}
\alias{getDateTime}
\title{Creates date-time objects for censored crime data}
\usage{
getDateTime(DATE_FROM, TIME_FROM, DATE_TO, TIME_TO, tz = "")
}
\arguments{
\item{DATE_FROM}{vector of earliest start dates for crimes}

\item{TIME_FROM}{vector of earliest start times for crimes}

\item{DATE_TO}{vector of latest end dates for crimes}

\item{TIME_TO}{vector of latest end times for crimes}

\item{tz}{timezone}
}
\value{
data frame with date-time (\code{POSIXlt}) fields: DT.FROM, DT.TO
  corresponding to the time range of (possibly) censored crime events
}
\description{
Takes censored crime data with separate date and time fields, attempts to
  repair bad or missing entries, and creates date-time objects.
}
\details{
\itemize{
             \item times must be in format: \code{\%H\%M}
             \item dates must be in format: \code{\%Y-\%m-\%d}
             }
}
\examples{
getDateTime("2014-03-20","1530","2014-03-22","0310")
}
\seealso{
\code{\link{fixDateTime}}
}

