% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_async.R
\name{crew_class_async}
\alias{crew_class_async}
\title{\code{R6} async class.}
\description{
\code{R6} class for async configuration.
}
\details{
See \code{\link[=crew_async]{crew_async()}}.
}
\seealso{
Other class: 
\code{\link{crew_class_client}},
\code{\link{crew_class_controller_group}},
\code{\link{crew_class_controller}},
\code{\link{crew_class_launcher}},
\code{\link{crew_class_tls}}
}
\concept{class}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{workers}}{See \code{\link[=crew_async]{crew_async()}}.}

\item{\code{instance}}{Character of length 1, name of the current instance.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_async-new}{\code{crew_class_async$new()}}
\item \href{#method-crew_class_async-validate}{\code{crew_class_async$validate()}}
\item \href{#method-crew_class_async-start}{\code{crew_class_async$start()}}
\item \href{#method-crew_class_async-eval}{\code{crew_class_async$eval()}}
\item \href{#method-crew_class_async-terminate}{\code{crew_class_async$terminate()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_async-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_async-new}{}}}
\subsection{Method \code{new()}}{
TLS configuration constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_async$new(workers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{workers}}{Argument passed from \code{\link[=crew_async]{crew_async()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} object with TLS configuration.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_async-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_async-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_async$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_async-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_async-start}{}}}
\subsection{Method \code{start()}}{
Start the local workers and error handling socket.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_async$start()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Does not create workers or an error handling socket
if \code{workers} is \code{NULL} or the object is already started.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_async-eval"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_async-eval}{}}}
\subsection{Method \code{eval()}}{
Run a local asynchronous task using a local
compute profile.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_async$eval(
  command,
  substitute = TRUE,
  data = list(),
  packages = character(0L),
  library = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{R code to run.}

\item{\code{substitute}}{Logical of length 1, whether to substitute \code{command}.
If \code{FALSE}, then \code{command} must be an expression object
or language object.}

\item{\code{data}}{Named list of data objects required to run \code{command}.}

\item{\code{packages}}{Character vector of packages to load.}

\item{\code{library}}{Character vector of library paths to load the packages
from.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Used for launcher plugins with asynchronous launches and
terminations. If \code{processes} is \code{NULL}, the task will run locally.
Otherwise, the task will run on a local process in the local
\code{mirai} compute profile.
}

\subsection{Returns}{
If the \code{processes} field is \code{NULL}, a list with an object named
\code{data} containing the result of evaluating \code{expr} synchronously.
Otherwise, the task is evaluated asynchronously, and the result
is a \code{mirai} task object. Either way, the \code{data} element
of the return value will contain the result of the task.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_async-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_async-terminate}{}}}
\subsection{Method \code{terminate()}}{
Start the local workers and error handling socket.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_async$terminate()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Waits for existing tasks to complete first.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
