% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/upfront_to_spread.R
\name{upfront_to_spread}
\alias{upfront_to_spread}
\title{Calculate Spread with a Given Upfront}
\usage{
upfront_to_spread(x, currency.var = "currency", date.var = "date",
  coupon.var = "coupon", tenor.var = "tenor", maturity.var = "maturity",
  recovery.var = "recovery", upfront.var = "upfront",
  points.var = "ptsUpfront", isPriceClean = FALSE, notional = 1e+07,
  payAccruedAtStart = FALSE, payAccruedOnDefault = TRUE)
}
\arguments{
\item{x}{data frame, contains all the relevant columns.}

\item{currency.var}{character, column in x containing currency.}

\item{date.var}{character, column in x containing date variable.}

\item{coupon.var}{character, column in x containing coupon rates in basis
points. It specifies the payment amount from the protection buyer to the
seller on an annual basis.}

\item{tenor.var}{character, column in x containing tenors.}

\item{maturity.var}{character, column in x containing maturity date.}

\item{recovery.var}{character, column in x containing recovery rates. ISDA
model standard recovery rate asscumption is 0.4.}

\item{upfront.var}{is the character name of upfront column}

\item{points.var}{character name of points Upfront column}

\item{isPriceClean}{a boolean variable indicating whether the upfront is clean or dirty}

\item{notional}{numeric variable indicating the notional value of the CDS contract}

\item{payAccruedAtStart}{whether pay at start date the accrual amount}

\item{payAccruedOnDefault}{whether pay in default scenario the accrual amount}

\item{recovery}{numeric, the recovery rate for all pricing if there isn't a
recovery.var}
}
\value{
a numeric indicating the spread.
}
\description{
\code{upfront_to_spread} calculates conventional spread using the upfront
or ptsUpfront values.
}

