% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tessdata.R
\name{tesseract_download}
\alias{tesseract_download}
\alias{tessdata}
\alias{tesseract_contributed_download}
\title{Tesseract Training Data}
\usage{
tesseract_download(
  lang,
  model = c("fast", "best"),
  datapath = NULL,
  progress = interactive()
)

tesseract_contributed_download(
  lang,
  model = c("fast", "best"),
  datapath = NULL,
  progress = interactive()
)
}
\arguments{
\item{lang}{three letter code for language, see
\href{https://github.com/tesseract-ocr/tessdata}{tessdata} repository.}

\item{model}{either \code{fast} or \code{best} is currently supported. The latter
downloads more accurate (but slower) trained models for Tesseract 4.0 or
higher}

\item{datapath}{destination directory where to download store the file}

\item{progress}{print progress while downloading}
}
\value{
no return value, called for side effects

no return value, called for side effects
}
\description{
Helper function to download training data from the official
\href{https://tesseract-ocr.github.io/tessdoc/Data-Files}{tessdata} repository.
On Linux, the fast training data can be installed directly with
yum or apt-get.

Helper function to download training data from the contributed
\href{https://github.com/tesseract-ocr/tessdata_contrib}{tessdata_contrib}
repository.
}
\details{
Tesseract uses training data to perform OCR. Most systems default to English
training data. To improve OCR performance for other languages you can to
install the training data from your distribution. For example to install the
spanish training data:
\itemize{
\item tesseract-ocr-spa (Debian, Ubuntu)
\item tesseract-langpack-spa (Fedora, EPEL)
}

On Windows and MacOS you can install languages using the \link{tesseract_download}
function which downloads training data directly from
\href{https://github.com/tesseract-ocr/tessdata}{github}
and stores it in a the path on disk given by the \code{TESSDATA_PREFIX} variable.
}
\examples{
# download the french training data
# this is wrapped around a \donttest{} block because otherwise the clang19
# CRAN check will fail with a "> 5 seconds" message
\donttest{
 dir <- tempdir()
 tesseract_download("fra", model = "best", datapath = dir)
 file <- system.file("examples", "french.png", package = "cpp11tesseract")
 text <- ocr(file, engine = tesseract("fra", datapath = dir))
 cat(text)
}
# download the greek training data
# this is wrapped around a \donttest{} block because otherwise the clang19
# CRAN check will fail with a "> 5 seconds" message
\donttest{
 dir <- tempdir()
 tesseract_contributed_download("grc_hist", model = "best", datapath = dir)
 file <- system.file("examples", "polytonicgreek.png",
   package = "cpp11tesseract")
 text <- ocr(file, engine = tesseract("grc_hist", datapath = dir))
 cat(text)
}
}
\references{
\href{https://tesseract-ocr.github.io/tessdoc/Data-Files}{tesseract wiki: training data}

\href{https://tesseract-ocr.github.io/tessdoc/Data-Files}{tesseract wiki: training data}
}
\seealso{
\link{tesseract_download}

Other tesseract: 
\code{\link{ocr}()},
\code{\link{tesseract}()}

Other tesseract: 
\code{\link{ocr}()},
\code{\link{tesseract}()}
}
\concept{tesseract}
