% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bubble.R
\name{bubble_say}
\alias{bubble_say}
\alias{bubble_think}
\title{Thought/speech bubble/balloon}
\usage{
bubble_say(x, width = 60)

bubble_think(x, width = 60)
}
\arguments{
\item{x}{(character) a character vector}

\item{width}{(integer/numeric) width of each line. default: 60}
}
\value{
character vector of length greater than the input \code{x}
}
\description{
Thought/speech bubble/balloon
}
\details{
\code{bubble_say} gives the traditional bubble that you get when
you run \code{cowsay} on the command line, with carrots or slashes for the
sides, while \code{bubble_think} gives a slightly different bubble with
parens for the sides
}
\note{
modified from \url{https://github.com/schochastics/startifyR}
}
\examples{
\dontshow{if (rlang::is_installed("fortunes")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(fortunes)
quote <- as.character(fortune())
bubble_say(x = quote)

cat(bubble_say(paste(quote, collapse = " ")), sep = "\n")
ch <- animals[["chicken"]]
z <- paste(c(bubble_say(quote), bubble_tail(ch, "\\\\"), ch), collapse = "\n")
cat(z)
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_installed("fortunes") && interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
text_color <- sample(grDevices::colors(), 1)
text_style <- crayon::make_style(text_color)
text_style(bubble_say(quote))
\dontshow{\}) # examplesIf}
}
\seealso{
Other bubble: 
\code{\link{bubble_tail}()}
}
\concept{bubble}
