% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt.R
\name{estima_rt}
\alias{estima_rt}
\title{RT: Número efectivo de reproducción}
\usage{
estima_rt(
  datos_covid,
  entidades = c("AGUASCALIENTES", "BAJA CALIFORNIA", "BAJA CALIFORNIA SUR", "CAMPECHE",
    "CHIAPAS", "CHIHUAHUA", "CIUDAD DE MÉXICO", "COAHUILA DE ZARAGOZA", "COLIMA",
    "DURANGO", "GUANAJUATO", "GUERRERO", "HIDALGO", "JALISCO", "MÉXICO",
    "MICHOACÁN DE OCAMPO", "MORELOS", "NAYARIT", "NUEVO LEÓN", "OAXACA", "PUEBLA",
    "QUERÉTARO", "QUINTANA ROO", "SAN LUIS POTOSÍ", "SINALOA", "SONORA", "TABASCO",
    "TAMAULIPAS", "TLAXCALA", "VERACRUZ DE IGNACIO DE LA LLAVE", "YUCATÁN", "ZACATECAS"),
  group_by_entidad = TRUE,
  entidad_tipo = c("Unidad Medica", "Residencia", "Nacimiento"),
  fecha_tipo = c("Sintomas", "Ingreso", "Defuncion"),
  tipo_clasificacion = c("Sospechosos", "Confirmados COVID", "Negativo a COVID",
    "Inválido", "No realizado"),
  tipo_paciente = c("AMBULATORIO", "HOSPITALIZADO", "NO ESPECIFICADO"),
  list_name = "estima_rt",
  min_date = as.POSIXct("2020-01-01", tz = Sys.timezone(), format = "\%Y-\%m-\%d"),
  max_date = as.POSIXct(Sys.time()),
  method = "parametric_si",
  config = if (requireNamespace("EpiEstim", quietly = TRUE)) {
    
    EpiEstim::make_config(list(mean_si = 2.5, std_si = 1.6))
 } else {
     NULL
 },
  ...
)
}
\arguments{
\item{datos_covid}{(\strong{obligatorio}) Lista de \code{tibble}s o \code{duckdb}s resultante de
\code{\link[=descarga_datos_abiertos]{descarga_datos_abiertos()}} o \code{\link[=read_datos_abiertos]{read_datos_abiertos()}}}

\item{entidades}{(\strong{opcional})  Vector con las entidades de las unidades medicas a analizar.
Opciones: \code{AGUASCALIENTES}, \verb{BAJA CALIFORNIA}, \verb{BAJA CALIFORNIA SUR},
\code{CAMPECHE}, \code{CHIAPAS}, \code{CHIHUAHUA}, \verb{CIUDAD DE MEXICO},
\verb{COAHUILA DE ZARAGOZA} , \code{COLIMA}, \code{DURANGO}, \code{GUANAJUATO}, \code{GUERRERO},
\code{HIDALGO}, \code{JALISCO}, \code{MEXICO}, \verb{MICHOACAN DE OCAMPO}, \code{MORELOS},\code{NAYARIT}
\verb{NUEVO LEON}, \code{OAXACA} ,\code{PUEBLA}, \code{QUERETARO},\verb{QUINTANA ROO},
\verb{SAN LUIS POTOSI}, \code{SINALOA}, \code{SONORA}, \code{TABASCO}, \code{TAMAULIPAS},\code{TLAXCALA},
\verb{VERACRUZ DE IGNACIO DE LA LLAVE}, \code{YUCATAN}, \code{ZACATECAS}.}

\item{group_by_entidad}{(\strong{opcional}) \code{TRUE} obtiene los casos para cada entidad reportando
en cada fecha la entidad y los casos en dicha entidad. \code{FALSE}  junta las \code{entidades} sumando
sus casos en una sola observacion por cada fecha.}

\item{entidad_tipo}{(\strong{opcional}) Indica a que se refiere las \code{entidades} seleccionadas. Elige
una de las opciones: \verb{Unidad Medica} (entidad de la unidad medica), \code{Nacimiento}
(entidad de origen del individuo) o \code{Residencia} (entidad donde reside el individuo).}

\item{fecha_tipo}{(\strong{opcional}) Selecciona si la fecha que se utiliza es la fecha de \code{Ingreso}
(si aplica), la fecha de \code{Sintomas} o la de \code{Defuncion} (si aplica). El default es fecha de \code{Sintomas}.}

\item{tipo_clasificacion}{(\strong{opcional})  Vector con el tipo de clasificaciones (por la prueba)
a incluir:\code{Sospechosos},\verb{Confirmados COVID}, \verb{Negativo a COVID}, \verb{Inv\\u00e1lido}, \verb{No realizado}}

\item{tipo_paciente}{(\strong{opcional}) Vector con el tipo de pacientes a incluir. Opciones:
\code{AMBULATORIO}, \code{HOSPITALIZADO}, \verb{NO ESPECIFICADO}. Por default se incluyen todos.}

\item{list_name}{(\strong{opcional}) Asigna un nombre en la lista de datos a la base generada}

\item{min_date}{(\strong{opcional}) Mínima fecha a partir de la cual estimar el RT.}

\item{max_date}{(\strong{opcional}) Máxima fecha a partir de la cual estimar el RT.}

\item{method}{(\strong{opcional}) Metodo para estimar el RT con \code{\link[EpiEstim:estimate_R]{EpiEstim::estimate_R()}}. Por
default se recomienda el método paramétrico de intervalo serial \code{parametric_si}.}

\item{config}{(\strong{opcional}) Configuracion para la estimacion del RT usando
\code{\link[EpiEstim:make_config]{EpiEstim::make_config()}}. Por default se utiliza una media del intervalo serial
de \code{mean_si = 2.5} y una desviación estandar de \code{std_si = 1.6}. Sin embargo, como el intervalo
serial depende mucho de la variante se recomienda cambiarlo.}

\item{...}{(\strong{opcional}) Parámetros adicionales para \code{\link[EpiEstim:estimate_R]{EpiEstim::estimate_R()}}.}
}
\value{
Une a la lista de \code{datos_covid} una nueva entrada de nombre \code{list_name}
(default: \code{estima_rt}) con una base de datos (\code{tibble}) con los
resultados agregados.
\itemize{
\item \code{estima_rt} - Base de datos generara con los datos agregados (el nombre cambia si
se usa \code{list_name}).
\item dict - Diccionario de datos
\item dats - Datos originales (conexion a \code{duckdb} o \code{tibble})
\item disconnect  - Función para desconectarte de \code{duckdb}
\item ... - Cualquier otro elemento que ya existiera en \code{datos_covid}
}
}
\description{
\code{estima_rt} Calcula el número efectivo de reproducción por fecha y entidad usando
los metodos de \code{\link[EpiEstim:estimate_R]{EpiEstim::estimate_R()}}. Por default calcula el número efectivo de
reproducción para cada estado.
}
\details{
Se sugiere establecer una mínima fecha y una máxima fecha con \code{min_date} y
\code{max_date} para la estimación pues los intervalos seriales de omicron son distintos
a los de la variante delta.
}
\examples{

# Para el ejemplo usaremos los datos precargados (datosabiertos) pero tu puedes
# correr el ejemplo descargando informacion mas reciente.
datos_covid <- datosabiertos

# Casos a nivel nacional por estado en todos
\donttest{
suppressWarnings(
  datos_covid <- datos_covid |> estima_rt()
)
head(datos_covid$estima_rt)

# Cambios en la fecha de estimacion siguiendo la recomendacion
# y obtenemos todo a nivel nacional
datos_covid <- datos_covid |> estima_rt(
  min_date = as.POSIXct("2021-07-01"),
  max_date = as.POSIXct("2021-09-01"),
  list_name = "rt_min_max",
  group_by_entidad = FALSE
)
head(datos_covid$rt_min_max)

# Casos a nivel nacional en los confirmados
datos_covid <- datos_covid |>
  estima_rt(
    tipo_clasificacion = "Confirmados COVID",
    group_by_entidad = FALSE,
    list_name = "rt_confirmados"
  )
head(datos_covid$rt_confirmados)

#' # Cambios en los parametros de epiestim
# estos parametros no tienen razon de ser mas alla de mostrar como se cambian
datos_covid <- datos_covid |>
  estima_rt(
    group_by_entidad = FALSE,
    list_name = "config_rt",
    method = "uncertain_si", # Metodo de estimacion
    config = EpiEstim::make_config(
      mean_si = 2.4,
      std_si = 0.3,
      std_mean_si = 0.2,
      min_mean_si = 2,
      max_mean_si = 4,
      std_std_si = 0.1,
      min_std_si = 0.1,
      max_std_si = 1.0
    )
  )
head(datos_covid$config_rt)

# Casos en BC, BCS en los confirmados
datos_covid |>
  estima_rt(
    entidades = c("BAJA CALIFORNIA", "BAJA CALIFORNIA SUR"),
    tipo_clasificacion = "Confirmados COVID",
    group_by_entidad = TRUE,
    list_name = "rt_bc_bcs"
  ) |>
  plot_covid(
    df_name = "rt_bc_bcs", df_date_index = "FECHA_SINTOMAS",
    df_variable = "Mean(R)", df_covariates = "ENTIDAD_FEDERATIVA"
  )
}

# Finalmente desconectamos
datos_covid$disconnect()

}
\seealso{
\code{\link[=descarga_datos_abiertos]{descarga_datos_abiertos()}} \code{\link[=numero_pruebas]{numero_pruebas()}} \code{\link[=cfr]{cfr()}} \code{\link[=chr]{chr()}}
\code{\link[=positividad]{positividad()}} \code{\link[=casos]{casos()}}
}
