% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.covdepGE}
\alias{plot.covdepGE}
\title{Plot the Graphs Estimated by \code{covdepGE}}
\usage{
\method{plot}{covdepGE}(x, graph_colors = NULL, title_sum = TRUE, ...)
}
\arguments{
\item{x}{object of class \code{covdepGE}; return of \code{covdepGE} function}

\item{graph_colors}{\code{NULL} OR vector; the \eqn{j}-th element is the color for
the \eqn{j}-th graph. If \code{NULL}, all graphs will be colored with \code{"#500000"}.
\code{NULL} by default}

\item{title_sum}{logical; if \code{TRUE} the indices of the observations
corresponding to the graph will be included in the title. \code{TRUE} by default}

\item{...}{additional arguments will be ignored}
}
\value{
Returns list of \code{ggplot2} visualizations of unique graphs estimated
by \code{covdepGE}
}
\description{
Create a list of the unique graphs estimated by \code{covdepGE}
}
\examples{
\dontrun{
library(ggplot2)

# get the data
set.seed(12)
data <- generateData()
X <- data$X
Z <- data$Z
interval <- data$interval
prec <- data$true_precision

# get overall and within interval sample sizes
n <- nrow(X)
n1 <- sum(interval == 1)
n2 <- sum(interval == 2)
n3 <- sum(interval == 3)

# visualize the distribution of the extraneous covariate
ggplot(data.frame(Z = Z, interval = as.factor(interval))) +
  geom_histogram(aes(Z, fill = interval), color = "black", bins = n \%/\% 5)

# visualize the true precision matrices in each of the intervals

# interval 1
matViz(prec[[1]], incl_val = TRUE) +
  ggtitle(paste0("True precision matrix, interval 1, observations 1,...,", n1))

# interval 2 (varies continuously with Z)
cat("\nInterval 2, observations ", n1 + 1, ",...,", n1 + n2, sep = "")
int2_mats <- prec[interval == 2]
int2_inds <- c(5, n2 \%/\% 2, n2 - 5)
lapply(int2_inds, function(j) matViz(int2_mats[[j]], incl_val = TRUE) +
         ggtitle(paste("True precision matrix, interval 2, observation", j + n1)))

# interval 3
matViz(prec[[length(prec)]], incl_val = TRUE) +
  ggtitle(paste0("True precision matrix, interval 3, observations ",
                 n1 + n2 + 1, ",...,", n1 + n2 + n3))

# fit the model and visualize the estimated graphs
(out <- covdepGE(X, Z))
plot(out)

# visualize the posterior inclusion probabilities for variables (1, 3) and (1, 2)
inclusionCurve(out, 1, 2)
inclusionCurve(out, 1, 3)
}
}
