% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor2.R
\name{periodogram}
\alias{periodogram}
\title{Periodogram}
\usage{
periodogram(data, timecol, firstsubj, lastsubj, na.action)
}
\arguments{
\item{data}{data frame containing all the subjects and time data.}

\item{timecol}{Column number of the column containing the time data in the data frame.}

\item{firstsubj}{Column number of the first subject in the data frame.}

\item{lastsubj}{Column number of the last subject in the data frame. Same as \code{firstsubj} if performing single cosinor analysis.}

\item{na.action}{Action to be performed on missing values.}
}
\description{
Estimates the best-fitting period using iterative cosinor procedure.
}
\details{
Iterative cosinor procedure is performed as described in Klemfuss & Clopton (1993). Cosinor is performed iteratively with the period (\eqn{\tau}) increased by 1 in each iteration. Percent Rhythm is calculated in each iteration, which allows for an estimation of the best fitting period. A periodogram can be plotted, which shows Percent Rhythm (coefficient of determination) for each period.
}
\note{
The range of periods included in iterations starts from 3 (sinusoidality of the curve is not achieved for \eqn{\tau} < 3) and ends with the number of timepoints in the data.
}
\examples{
periodogram(timecol = 1, firstsubj = 2, lastsubj = 20, data = PANAS_november, na.action =
"na.exclude")

periodogram(timecol = 1, firstsubj = 2, lastsubj = 2, data = temperature_zg)
}
\references{
Klemfuss, H. & Clopton, P. L. (1993). Seeking Tau: A Comparison of Six Methods. \emph{Journal of Interdisciplinary Cycle Research}, \emph{24(1)}, 1-16.
}
\seealso{
\code{\link{cosinor.PR}}
}
