% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_dictionary.r
\name{search_dictionary}
\alias{search_dictionary}
\title{Dictionary lookup}
\usage{
search_dictionary(
  tc,
  dict,
  token_col = "token",
  string_col = "string",
  code_col = "code",
  sep = " ",
  mode = c("unique_hits", "features"),
  case_sensitive = F,
  use_wildcards = T,
  standardize = T,
  ascii = F,
  verbose = F
)
}
\arguments{
\item{tc}{A tCorpus}

\item{dict}{A dictionary. Can be either a data.frame or a quanteda dictionary. If a data.frame is given, it has to
have a column named "string"  (or use string_col argument) that contains the dictionary terms, and a column "code" (or use code_col argument) that contains the
label/code represented by this string. Each row has a single string, that can be
a single word or a sequence of words seperated by a whitespace (e.g., "not bad"), and can have the common ? and * wildcards.
If a quanteda dictionary is given, it is automatically converted to this type of data.frame with the
\code{\link{melt_quanteda_dict}} function. This can be done manually for more control over labels.}

\item{token_col}{The feature in tc that contains the token text.}

\item{string_col}{If dict is a data.frame, the name of the column in dict with the dictionary lookup string. Default is "string"}

\item{code_col}{The name of the column in dict with the dictionary code/label. Default is "code".
If dict is a quanteda dictionary with multiple levels, "code_l2", "code_l3", etc. can be used to select levels..}

\item{sep}{A regular expression for separating multi-word lookup strings (default is " ", which is what quanteda dictionaries use).
For example, if the dictionary contains "Barack Obama", sep should be " " so that it matches the consequtive tokens "Barack" and "Obama".
In some dictionaries, however, it might say "Barack+Obama", so in that case sep = '\\+' should be used.}

\item{mode}{There are two modes: "unique_hits" and "features". The "unique_hits" mode prioritizes finding unique matches, which is recommended for counting how often a dictionary term occurs.
If a term matches multiple dictionary terms (which should only happen for nested multi-word terms, such as "bad" and "not bad"), the longest term is always used. 
The features mode does not delete duplicates.}

\item{case_sensitive}{logical, should lookup be case sensitive?}

\item{use_wildcards}{Use the wildcards * (any number including none of any character) and ? (one or none of any character). If FALSE, exact string matching is used}

\item{standardize}{If true, standardize how terms in the corpus and dictionary are tokenized. This prevens mismatching in cases like collocations ("Barack_Obama" versus "Barack" "Obama") and emoticons}

\item{ascii}{If true, convert text to ascii before matching}

\item{verbose}{If true, report progress}
}
\value{
A vector with the id value (taken from dict$id) for each row in tc$tokens
}
\description{
Similar to search_features, but for fast matching of large dictionaries.
}
\examples{
dict = data.frame(string = c('this is', 'for a', 'not big enough'), code=c('a','c','b'))
tc = create_tcorpus(c('this is a test','This town is not big enough for a test'))
search_dictionary(tc, dict)$hits
}
