% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_words.r
\name{dtm_wordcloud}
\alias{dtm_wordcloud}
\title{Plot a word cloud from a dtm}
\usage{
dtm_wordcloud(dtm = NULL, nterms = 100, freq.fun = NULL, terms = NULL,
  freqs = NULL, scale = c(6, 0.5), min.freq = 1, rot.per = 0.15, ...)
}
\arguments{
\item{dtm}{the document-term matrix}

\item{nterms}{the amount of words to plot (default 100)}

\item{freq.fun}{if given, will be applied to the frequenies (e.g. sqrt)}

\item{terms}{the terms to plot, ignored if dtm is given}

\item{freqs}{the frequencies to plot, ignored if dtm is given}

\item{scale}{the scale to plot (see wordcloud::wordcloud)}

\item{min.freq}{the minimum frquency to include (see wordcloud::wordcloud)}

\item{rot.per}{the percentage of vertical words (see wordcloud::wordcloud)}

\item{...}{other arguments passed to wordcloud::wordcloud}
}
\description{
Compute the term frequencies for the dtm and plot a word cloud with the top n topics
You can either supply a document-term matrix or provide terms and freqs directly
(in which case this is an alias for wordcloud::wordcloud with sensible defaults)
}
\examples{
## create DTM
tc = create_tcorpus(sotu_texts[1:100,], doc_column = 'id')
tc$preprocess('token', 'feature', remove_stopwords = TRUE)
dtm = tc$dtm('feature')

\dontrun{
dtm_wordcloud(dtm, nterms = 20)

## or without a DTM
dtm_wordcloud(terms = c('in','the','cloud'), freqs = c(2,5,10))
}
}
