/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data.pojo;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import uno.informatics.data.SimpleEntity;
import uno.informatics.data.pojo.PropertyHandler;

public class SimpleEntityPojo
extends PropertyHandler
implements SimpleEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String UNIQUE_IDENTIFIER_PROPERTY = SimpleEntity.class.getName() + ".unuqueIdentifier";
    public static final String NAME_PROPERTY = SimpleEntity.class.getName() + ".name";
    private String uniqueIdentifier;
    private String name;

    public SimpleEntityPojo(String uniqueIdentifier) {
        this(uniqueIdentifier, uniqueIdentifier);
    }

    public SimpleEntityPojo(String uniqueIdentifier, String name) {
        this.initialise();
        this.setUniqueIdentifier(uniqueIdentifier);
        this.setName(name);
    }

    public SimpleEntityPojo(SimpleEntity simpleEntity) {
        this.initialise();
        if (simpleEntity == null) {
            throw new NullPointerException("Simple Entity is not optional!");
        }
        this.setUniqueIdentifier(simpleEntity.getUniqueIdentifier());
        this.setName(simpleEntity.getName());
    }

    @Override
    public final String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public final void setUniqueIdentifier(String uniqueIdentifier) {
        String oldValue = this.uniqueIdentifier;
        this.uniqueIdentifier = uniqueIdentifier;
        this.getPropertyChangeSupport().firePropertyChange(UNIQUE_IDENTIFIER_PROPERTY, oldValue, this.uniqueIdentifier);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.getPropertyChangeSupport().firePropertyChange(NAME_PROPERTY, oldValue, this.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.uniqueIdentifier);
        return result;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof SimpleEntity) {
            SimpleEntity se = (SimpleEntity)object;
            return this.getUniqueIdentifier() != null && se.getUniqueIdentifier() != null && StringUtils.equals(se.getUniqueIdentifier(), this.getUniqueIdentifier());
        }
        return false;
    }

    protected void initialise() {
        this.uniqueIdentifier = null;
        this.name = null;
    }
}

