/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.subset.validations;

import org.jamesframework.core.problems.constraints.validations.Validation;

public class SubsetValidation
implements Validation {
    private final boolean validSize;
    private final Validation constraintValidation;

    public SubsetValidation(boolean validSize, Validation constraintValidation) {
        this.validSize = validSize;
        this.constraintValidation = constraintValidation;
    }

    public boolean validSize() {
        return this.validSize;
    }

    public Validation getConstraintValidation() {
        return this.constraintValidation;
    }

    public boolean passed(boolean checkSize) {
        return !(checkSize && !this.validSize || this.constraintValidation != null && !this.constraintValidation.passed());
    }

    @Override
    public boolean passed() {
        return this.passed(true);
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.passed() ? "valid" : "invalid");
        str.append(" (");
        if (this.validSize()) {
            str.append("valid size");
        } else {
            str.append("invalid size");
        }
        if (this.constraintValidation != null) {
            str.append(", ");
            if (this.constraintValidation.passed()) {
                str.append("constraints satisfied");
            } else {
                str.append("constraints not satisfied");
            }
        }
        str.append(")");
        return str.toString();
    }
}

