/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.data;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.corehunter.CoreHunterMeasure;
import org.corehunter.CoreHunterObjectiveType;
import org.corehunter.data.DistanceMatrixData;
import org.corehunter.data.GenotypeData;
import org.jamesframework.core.problems.datatypes.IntegerIdentifiedData;
import uno.informatics.data.Data;
import uno.informatics.data.SimpleEntity;
import uno.informatics.data.dataset.FeatureData;
import uno.informatics.data.pojo.DataPojo;

public class CoreHunterData
extends DataPojo
implements IntegerIdentifiedData {
    private static final long serialVersionUID = 1L;
    private static final List<CoreHunterMeasure> NO_MEASURES = new LinkedList<CoreHunterMeasure>();
    private final GenotypeData genotypicData;
    private final FeatureData phenotypicData;
    private final DistanceMatrixData distancesData;
    private final List<CoreHunterObjectiveType> validObjectiveTypes;
    private final List<CoreHunterMeasure> validMeasures;

    public CoreHunterData(GenotypeData genotypicData, FeatureData phenotypicData, DistanceMatrixData distancesData) {
        super("Core Hunter data", CoreHunterData.mergeHeaders(genotypicData, phenotypicData, distancesData));
        this.genotypicData = genotypicData;
        this.phenotypicData = phenotypicData;
        this.distancesData = distancesData;
        this.validObjectiveTypes = new LinkedList<CoreHunterObjectiveType>();
        this.validMeasures = new LinkedList<CoreHunterMeasure>();
        if (genotypicData != null || phenotypicData != null || distancesData != null) {
            this.validObjectiveTypes.add(CoreHunterObjectiveType.AV_ENTRY_TO_ENTRY);
            this.validObjectiveTypes.add(CoreHunterObjectiveType.AV_ENTRY_TO_NEAREST_ENTRY);
            this.validObjectiveTypes.add(CoreHunterObjectiveType.AV_ACCESSION_TO_NEAREST_ENTRY);
            if (genotypicData != null) {
                this.validObjectiveTypes.add(CoreHunterObjectiveType.COVERAGE);
                this.validObjectiveTypes.add(CoreHunterObjectiveType.HETEROZYGOUS_LOCI);
                this.validObjectiveTypes.add(CoreHunterObjectiveType.SHANNON_DIVERSITY);
                this.validMeasures.add(CoreHunterMeasure.MODIFIED_ROGERS);
                this.validMeasures.add(CoreHunterMeasure.CAVALLI_SFORZA_EDWARDS);
            }
            if (phenotypicData != null) {
                this.validMeasures.add(CoreHunterMeasure.GOWERS);
            }
            if (distancesData != null) {
                this.validMeasures.add(CoreHunterMeasure.PRECOMPUTED_DISTANCE);
            }
        }
    }

    public CoreHunterData(GenotypeData genotypicData) {
        this(genotypicData, null, null);
    }

    public CoreHunterData(FeatureData phenotypicData) {
        this(null, phenotypicData, null);
    }

    public CoreHunterData(DistanceMatrixData distancesData) {
        this(null, null, distancesData);
    }

    public GenotypeData getGenotypicData() {
        return this.genotypicData;
    }

    public FeatureData getPhenotypicData() {
        return this.phenotypicData;
    }

    public DistanceMatrixData getDistancesData() {
        return this.distancesData;
    }

    public boolean hasGenotypes() {
        return this.genotypicData != null;
    }

    public boolean hasPhenotypes() {
        return this.phenotypicData != null;
    }

    public boolean hasDistances() {
        return this.distancesData != null;
    }

    private static int inferSize(GenotypeData genotypicData, FeatureData phenotypicData, DistanceMatrixData distancesData) {
        boolean sameSize;
        if (genotypicData == null && phenotypicData == null && distancesData == null) {
            throw new IllegalArgumentException("At least one type of data (genotypic, phenotypic, distances) should be defined.");
        }
        int[] sizes = Arrays.asList(genotypicData, phenotypicData, distancesData).stream().filter(Objects::nonNull).mapToInt(Data::getSize).distinct().toArray();
        boolean bl = sameSize = sizes.length == 1;
        if (!sameSize) {
            if (sizes.length == 2) {
                throw new IllegalArgumentException(String.format("Provided datasets have different sizes. %d %d", sizes[0], sizes[1]));
            }
            if (sizes.length == 3) {
                throw new IllegalArgumentException(String.format("Provided datasets have different sizes. %d %d %d", sizes[0], sizes[1], sizes[2]));
            }
        }
        return sizes[0];
    }

    private static SimpleEntity[] mergeHeaders(GenotypeData genotypicData, FeatureData phenotypicData, DistanceMatrixData distancesData) {
        int size = CoreHunterData.inferSize(genotypicData, phenotypicData, distancesData);
        SimpleEntity[] headers = Arrays.asList(genotypicData, phenotypicData, distancesData).stream().filter(Objects::nonNull).map(data -> {
            SimpleEntity[] h = new SimpleEntity[data.getSize()];
            for (int i = 0; i < h.length; ++i) {
                h[i] = data.getHeader(i);
            }
            return h;
        }).reduce((headers1, headers2) -> {
            SimpleEntity[] h = new SimpleEntity[((SimpleEntity[])headers1).length];
            for (int i = 0; i < h.length; ++i) {
                SimpleEntity h1 = headers1[i];
                SimpleEntity h2 = headers2[i];
                if (h1 == null) {
                    h[i] = h2;
                    continue;
                }
                if (h2 == null) {
                    h[i] = h1;
                    continue;
                }
                if (h1.equals(h2)) {
                    if (h1.getName() != null && h2.getName() != null && !h1.getName().equals(h2.getName())) {
                        throw new IllegalArgumentException(String.format("Headers do not match for item %d. Got same id %s but different names %s and %s.", i, h1.getUniqueIdentifier(), h1.getName(), h2.getName()));
                    }
                    if (h1.getName() != null) {
                        h[i] = h1;
                        continue;
                    }
                    h[i] = h2;
                    continue;
                }
                throw new IllegalArgumentException(String.format("Headers do not match for item %d. Got different ids %s and %s.", i, h1.getUniqueIdentifier(), h2.getUniqueIdentifier()));
            }
            return h;
        }).get();
        if (Arrays.stream(headers).allMatch(Objects::isNull)) {
            headers = DataPojo.updateOrCreateHeaders(null, size);
        }
        return headers;
    }

    public final List<CoreHunterObjectiveType> getValidObjectiveTypes() {
        return this.validObjectiveTypes;
    }

    public final List<CoreHunterMeasure> getValidMeasures(CoreHunterObjectiveType objectiveType) {
        switch (objectiveType) {
            case AV_ACCESSION_TO_NEAREST_ENTRY: 
            case AV_ENTRY_TO_ENTRY: 
            case AV_ENTRY_TO_NEAREST_ENTRY: {
                return this.validMeasures;
            }
        }
        return NO_MEASURES;
    }
}

