% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paircount.R
\name{paircount}
\alias{paircount}
\title{Count the number of point-pairs in distance bins}
\usage{
paircount(x, y = NULL, dr, rmax, cpp = TRUE)
}
\arguments{
\item{x}{n-element vector or n-by-d matrix of d-dimensional positions of data points}

\item{y}{optional m-element vector or m-by-d matrix of d-dimensional positions of a second point set}

\item{dr}{distance bin size}

\item{rmax}{maximum distance to be considered}

\item{cpp}{logical flag; if set to TRUE (default) a fast implementation in C++ is used, otherwise the counting is performed less efficiently in R.}
}
\value{
Returns a list with two vectors
\item{r}{vector with the mid-points of the distance bins.}
\item{n}{number of pairs in the distance bin.}
}
\description{
Count the number of point-pairs in equally spaced distances bins. Code works in any dimension. If only one point set is provided, the distances of this point set with itself are used (counting each pairs only once, i.e. only ij, not ji).
}
\seealso{
\code{\link{landyszalay}}
}
\author{
Danail Obreschkow
}
