% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull.R
\name{pull_github}
\alias{pull_github}
\title{Pull contributions from GitHub}
\usage{
pull_github(data = NULL, repo = NULL, owner = NULL,
  username = NULL, role = NULL, report_lines = FALSE,
  type = c("all", "add", "del"), .token = NULL)
}
\arguments{
\item{data}{a \code{data.frame} contains columns 'repo', 'owner', 'username' and 'role'.
You can also pass them one by one to the following parameters.}

\item{repo}{repository name.}

\item{owner}{repository owner.}

\item{username}{username to pull.}

\item{role}{user role in this repository.}

\item{report_lines}{if \code{TRUE}, report contributed lines.}

\item{type}{'all' for the sum of number of additions and deletions,
'add' for the number of additions and 'del' for the number of deletions.}

\item{.token}{Authentication token. See \code{\link[=pull_github_limit]{pull_github_limit()}}.}
}
\value{
a `data.frame``
}
\description{
Pull contributions from GitHub
}
\examples{
pull_github(
  repo = "UCSCXenaTools", owner = "ShixiangWang",
  username = "ShixiangWang", role = "developer"
)
}
