% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-raw.R
\name{opts_raw}
\alias{opts_raw}
\title{Constructive options for type 'raw'}
\usage{
opts_raw(
  constructor = c("as.raw", "charToRaw"),
  ...,
  trim = NULL,
  fill = c("default", "rlang", "+", "...", "none"),
  compress = TRUE,
  representation = c("hexadecimal", "decimal")
)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the object.}

\item{...}{Additional options used by user defined constructors through the \code{opts} object}

\item{trim}{\code{NULL} or integerish. Maximum of elements showed before it's trimmed.
Note that it will necessarily produce code that doesn't reproduce the input.
This code will parse without failure but its evaluation might fail.}

\item{fill}{String. Method to use to represent the trimmed elements. See \code{?opts_atomic}}

\item{compress}{Boolean. If \code{TRUE} instead of \code{c()} Use \code{seq()}, \code{rep()}
when relevant to simplify the output.}

\item{representation}{For "as.raw" constructor. Respectively generate output
in the formats \code{as.raw(0x10)} or \code{as.raw(16)}}
}
\value{
An object of class <constructive_options/constructive_options_raw>
}
\description{
These options will be used on objects of type 'raw'.

Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"as.raw"} (default): Use \code{as.raw()}, or \code{raw()} when relevant
\item \code{"charToRaw"} : Use \code{charToRaw()} on a string, if the a raw vector contains
a zero we fall back to the "as.raw" constructor.
}

To set options on all atomic types at once see \link{opts_atomic}().
}
