% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dat2fre.R
\name{dat2fre}
\alias{dat2fre}
\title{dataset to pattern frequency conversion}
\usage{
dat2fre(x, katorder = FALSE, caseorder = TRUE, kat = NULL, codes = NULL)
}
\arguments{
\item{x}{an object of class "matrix" or "data.frame". If \code{x} is a "data.frame" each variable (column) must be an \code{integer} or a \code{factor}. If \code{x} is a "matrix" it is assumed that the categories for each variable in \code{x} start with \code{1} -- there is no check for that !!!}

\item{katorder}{logical with default set to \code{katorder==FALSE}. When set to \code{katorder==TRUE} variables are ordered according to their number of categories (variable with most categories is the rightmost variable) in the resulting object.}

\item{caseorder}{logical with default set to \code{caseorder==TRUE}. When set to \code{caseorder==FALSE} configurations are only ordered according to the categories of the rightmost variable in the resulting object.}

\item{kat}{ignored when \code{x} is a \code{data.frame}! If \code{x} is a \code{"matrix"} the optional argument \code{kat} must be an integer vector defining the number of categories for every variable in \code{x} (in the respective order). If left empty the (max) number of categories ist estimated from the data given in \code{x}.}

\item{codes}{a list with character vectors containing coding for integers in matrix (if \code{x} is a numeric \code{matrix}). If \code{codes} is not empty (and the argument \code{x} is an object of class "matrix") the return object will be pattern frequencies table as \code{data.frame}.}
}
\value{
An object of class c("data.frame","Pfreq") containing the (response) pattern frequencies table representation of the given dataset in the argument \code{x}.
}
\description{
Given a dataset this function returns a (response) pattern frequencies table representation of it.
}
\details{
No further details
}
\examples{
#######################################
data(suicide)# loading data in data frame (702 cases) representation
dat2fre(suicide) # converting it into a pattern frequencies table

###########
#######################################
data(LienertLSD)# loading example pattern frequencies table ..
test<-fre2dat(LienertLSD)# and coverting it into a simple (data) matrix
test<-test[sample(c(1:65),65),] # making a messy order
############
dat2fre(test) # making a proper ordered pattern frequencies table again
##### try it with a data.frame too!
#######################################
}
\references{
No references in the moment
}

